/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.XTSException;
import com.cognos.xts.application.ApplicationUtils;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.PathUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class XTSApplication {
    private static final String APPLICATION_TAG = "application";
    private static final String OPTION_FILE = "system.xml";
    private static final String CONFIG_FILE = "application.xml";

    public static void parse(DirEnt app, HashMap parent_soMap, HashMap parent_poMap, double curVersion) throws XTSException {
        if (app == null) {
            return;
        }
        String appPath = null;
        try {
            appPath = PathUtils.buildPath(app.getPath());
        }
        catch (IOException e) {
            throw new XTSException("application.invalidpath", e);
        }
        HashMap soMap = new HashMap();
        soMap.putAll(parent_soMap);
        try {
            String optionFile = PathUtils.buildPath(appPath, OPTION_FILE);
            Element sysEle = ApplicationUtils.readFile(optionFile);
            if (sysEle != null) {
                if (!sysEle.getName().equals("system")) {
                    throw new XTSException("application.invalidsystemxml");
                }
                sysEle = ApplicationUtils.upgradeSystem(optionFile, sysEle, curVersion);
                ApplicationUtils.updateSystemOptionsMap(soMap, sysEle);
            }
        }
        catch (IOException e) {
            throw new XTSException("application.invalidsystemxml", e);
        }
        Element resultSysEle = ApplicationUtils.createSystemElement(soMap);
        XTSApplicationManager.getInstance().getSystemOptionsMap().setSystemOptions(appPath, resultSysEle);
        HashMap poMap = new HashMap();
        poMap.putAll(parent_poMap);
        try {
            String configFile = PathUtils.buildPath(appPath, CONFIG_FILE);
            Element configEle = ApplicationUtils.readFile(configFile);
            if (configEle != null) {
                if (!configEle.getName().equals(APPLICATION_TAG)) {
                    throw new XTSException("application.invalidrootxml");
                }
                Element poEle = configEle.element("processing");
                if (poEle != null) {
                    ApplicationUtils.updateProcessingOptionsMap(poMap, poEle);
                }
            }
        }
        catch (IOException e) {
            throw new XTSException("application.invalidprocessingxml", e);
        }
        Element resultPoEle = ApplicationUtils.createProcessingOptionsElement(poMap);
        XTSApplicationManager.getInstance().getProcessingOptionsMap().setProcessingOptions(appPath, resultPoEle);
        List ifaces = app.getChildren();
        if (ifaces != null) {
            for (int i = 0; i < ifaces.size(); ++i) {
                DirEnt iface = (DirEnt)ifaces.get(i);
                XTSInterface.parse(iface, soMap, poMap, curVersion);
            }
        }
    }
}

