/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.XTSException;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.application.XTSInterfaceMap;
import com.cognos.xts.application.XTSProcessingOptionsMap;
import com.cognos.xts.application.XTSRoot;
import com.cognos.xts.application.XTSSystemOptionsMap;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public class XTSApplicationManager
extends AXTSManager {
    private static final String m_identifier = "XTSApplicationManager";
    private static final XTSApplicationManager m_instance = new XTSApplicationManager();
    private XTSInterfaceMap m_iMap = null;
    private XTSProcessingOptionsMap m_poMap = null;
    private XTSSystemOptionsMap m_soMap = null;

    public static XTSApplicationManager getInstance() {
        return m_instance;
    }

    private XTSApplicationManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return true;
    }

    @Override
    protected synchronized void initialize_Impl() throws XTSException {
        this.m_iMap = new XTSInterfaceMap();
        this.m_poMap = new XTSProcessingOptionsMap();
        this.m_soMap = new XTSSystemOptionsMap();
        DirEnt root = XTSResourceManager.getInstance().getTemplateRoot();
        XTSRoot.parse(root);
    }

    @Override
    protected synchronized void terminate_Impl() throws XTSException {
        this.m_iMap = null;
        this.m_poMap = null;
        this.m_soMap = null;
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public XTSInterfaceMap getInterfaceMap() {
        return this.m_iMap;
    }

    public XTSProcessingOptionsMap getProcessingOptionsMap() {
        return this.m_poMap;
    }

    public XTSSystemOptionsMap getSystemOptionsMap() {
        return this.m_soMap;
    }

    public Element getSystemOptions(String path) {
        String sPath = PathUtils.normalizeToPath(path);
        return this.m_soMap.getSystemOptions(sPath);
    }

    public Element getDefaultSystemOptions() {
        return this.m_soMap.getSystemOptions("");
    }

    public Element getProcessingOptions(String path) {
        String sPath = PathUtils.normalizeToPath(path);
        return this.m_poMap.getProcessingOptions(sPath);
    }

    public Element getDefaultProcessingOptions() {
        return this.m_poMap.getProcessingOptions("");
    }

    public Element searchSystemOptions(String path) {
        String sPath = null;
        try {
            sPath = PathUtils.buildPath(path);
        }
        catch (IOException e) {
            return null;
        }
        while (sPath.length() > 0) {
            Element option = this.m_soMap.getSystemOptions(sPath);
            if (option != null) {
                return option;
            }
            int idx = sPath.lastIndexOf("/");
            if (idx == -1) break;
            sPath = sPath.substring(0, idx);
        }
        return this.m_soMap.getSystemOptions("");
    }

    public Element searchProcessingOptions(String path) {
        String sPath = null;
        try {
            sPath = PathUtils.buildPath(path);
        }
        catch (IOException e) {
            return null;
        }
        while (sPath.length() > 0) {
            Element option = this.m_poMap.getProcessingOptions(sPath);
            if (option != null) {
                return option;
            }
            int idx = sPath.lastIndexOf("/");
            if (idx == -1) break;
            sPath = sPath.substring(0, idx);
        }
        return this.m_poMap.getProcessingOptions("");
    }

    public XTSInterface getInterfaceByName(String vPath, String name) {
        return this.m_iMap.getInterfaceByName(vPath, name);
    }

    public XTSInterface getInterfaceByNS(String vPath, String ns) {
        return this.m_iMap.getInterfaceByNS(vPath, ns);
    }

    public List searchInterface(String vPath) {
        return this.m_iMap.searchInterfaceByVPath(vPath);
    }

    public XTSInterface getInterface(String vPath, String id) {
        XTSInterface iface = this.m_iMap.getInterfaceByName(vPath, id);
        if (iface == null) {
            iface = this.m_iMap.getInterfaceByNS(vPath, id);
        }
        return iface;
    }
}

