/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.XTSException;
import com.cognos.xts.application.ApplicationUtils;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.PathUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class XTSInterface {
    private static final String INTERFACE_TAG = "interface";
    private static final String OPTION_FILE = "system.xml";
    private static final String CONFIG_FILE = "interface.xml";
    private static final String INTERFACE_NAME = "name";
    private static final String INTERFACE_TARGETNAMESPACE = "targetNamespace";
    private static final String INTERFACE_VIRTUALPATH = "virtualPath";
    private static final String INTERFACE_OPERATION = "operation";
    private static final String INTERFACE_OPERATION_NAME = "name";
    private static final String MORPHLET = "morphlet";
    private static final String MORPHLET_PATH = "path";
    private HashMap m_soMap = null;
    private HashMap m_poMap = null;
    private String m_interfacePath = null;
    private String m_interfaceName = null;
    private String m_targetNameSpace = null;
    private String m_virtualPath = null;
    private HashMap m_operations = null;
    private Element m_soEle = null;
    private Element m_poEle = null;

    public static void parse(DirEnt iface, HashMap parent_soMap, HashMap parent_poMap, double curVersion) throws XTSException {
        List subifaces;
        if (iface == null) {
            return;
        }
        String iPath = null;
        try {
            iPath = PathUtils.buildPath(iface.getPath());
        }
        catch (IOException e) {
            throw new XTSException("application.invalidpath", e);
        }
        Element sysEle = null;
        Element poEle = null;
        Element ifaceEle = null;
        HashMap soMap = new HashMap();
        soMap.putAll(parent_soMap);
        try {
            String optionFile = PathUtils.buildPath(iPath, OPTION_FILE);
            sysEle = ApplicationUtils.readFile(optionFile);
            if (sysEle != null) {
                if (!sysEle.getName().equals("system")) {
                    throw new XTSException("application.invalidsystemxml");
                }
                sysEle = ApplicationUtils.upgradeSystem(optionFile, sysEle, curVersion);
                ApplicationUtils.updateSystemOptionsMap(soMap, sysEle);
            }
        }
        catch (IOException e) {
            throw new XTSException("application.invalidsystemxml", e);
        }
        Element resultSysEle = ApplicationUtils.createSystemElement(soMap);
        XTSApplicationManager.getInstance().getSystemOptionsMap().setSystemOptions(iPath, resultSysEle);
        HashMap poMap = new HashMap();
        poMap.putAll(parent_poMap);
        try {
            String configFile = PathUtils.buildPath(iPath, CONFIG_FILE);
            ifaceEle = ApplicationUtils.readFile(configFile);
            if (ifaceEle != null) {
                if (!ifaceEle.getName().equals(INTERFACE_TAG)) {
                    throw new XTSException("application.invalidrootxml");
                }
                poEle = ifaceEle.element("processing");
                if (poEle != null) {
                    ApplicationUtils.updateProcessingOptionsMap(poMap, poEle);
                }
            }
        }
        catch (IOException e) {
            throw new XTSException("application.invalidprocessingxml", e);
        }
        Element resultPoEle = ApplicationUtils.createProcessingOptionsElement(poMap);
        XTSApplicationManager.getInstance().getProcessingOptionsMap().setProcessingOptions(iPath, resultPoEle);
        if (ifaceEle != null) {
            XTSInterface.loadOperations(ifaceEle, iPath, soMap, poMap, resultSysEle, resultPoEle);
        }
        if ((subifaces = iface.getChildren()) != null) {
            for (int i = 0; i < subifaces.size(); ++i) {
                DirEnt subiface = (DirEnt)subifaces.get(i);
                XTSInterface.parse(subiface, soMap, poMap, curVersion);
            }
        }
    }

    private static void loadOperations(Element ifaceEle, String path, HashMap soMap, HashMap poMap, Element sysEle, Element poEle) throws XTSException {
        if (ifaceEle == null) {
            return;
        }
        XTSInterface iface = new XTSInterface();
        iface.m_soMap = soMap;
        iface.m_poMap = poMap;
        iface.m_soEle = sysEle;
        iface.m_poEle = poEle;
        iface.m_operations = new HashMap();
        iface.m_interfacePath = path;
        if (!iface.m_interfacePath.startsWith("/")) {
            iface.m_interfacePath = "/" + iface.m_interfacePath;
        }
        iface.m_interfaceName = ifaceEle.attributeValue("name");
        iface.m_targetNameSpace = ifaceEle.attributeValue(INTERFACE_TARGETNAMESPACE);
        iface.m_virtualPath = ifaceEle.attributeValue(INTERFACE_VIRTUALPATH);
        if (iface.m_virtualPath == null) {
            iface.m_virtualPath = "/";
        } else {
            if (!iface.m_virtualPath.startsWith("/")) {
                iface.m_virtualPath = "/" + iface.m_virtualPath;
            }
            if (!iface.m_virtualPath.endsWith("/")) {
                iface.m_virtualPath = iface.m_virtualPath + "/";
            }
        }
        List operationElements = ifaceEle.elements(INTERFACE_OPERATION);
        for (Element operationElement : operationElements) {
            if (operationElement == null) continue;
            String operationName = operationElement.attributeValue("name");
            Element morphletElement = operationElement.element(MORPHLET);
            if (morphletElement == null) continue;
            String mPath = morphletElement.attributeValue(MORPHLET_PATH);
            if (operationName == null || mPath == null) continue;
            try {
                mPath = PathUtils.buildPath(mPath);
                if (!mPath.startsWith("/")) {
                    mPath = "/" + mPath;
                }
                iface.m_operations.put(operationName, mPath);
            }
            catch (IOException e) {
                Object[] args = new String[]{path};
                throw new XTSException("application.invalidinterfacexml", args, e);
            }
        }
        XTSApplicationManager.getInstance().getInterfaceMap().setInterfaceByName(iface.m_virtualPath, iface.m_interfaceName, iface);
        XTSApplicationManager.getInstance().getInterfaceMap().setInterfaceByNS(iface.m_virtualPath, iface.m_targetNameSpace, iface);
    }

    public String getInterfacePath() {
        return this.m_interfacePath;
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public String getMorphlet(String operation) {
        if (operation != null) {
            return (String)this.m_operations.get(operation);
        }
        return null;
    }

    public Element getSystemOptions() {
        if (this.m_soEle != null) {
            return this.m_soEle.createCopy();
        }
        return null;
    }

    public Element getProcessingOptions() {
        if (this.m_poEle != null) {
            return this.m_poEle.createCopy();
        }
        return null;
    }

    public void getOperations(Map operations) {
        operations.putAll(this.m_operations);
    }

    public void merge(XTSInterface iface) throws XTSException {
        Element processingEle;
        if (iface == this) {
            return;
        }
        iface.getOperations(this.m_operations);
        Element systemEle = iface.getSystemOptions();
        if (systemEle != null) {
            ApplicationUtils.updateSystemOptionsMap(this.m_soMap, systemEle);
            this.m_soEle = ApplicationUtils.createSystemElement(this.m_soMap);
            XTSApplicationManager.getInstance().getSystemOptionsMap().setSystemOptions(this.m_interfacePath, this.m_soEle);
        }
        if ((processingEle = iface.getProcessingOptions()) != null) {
            ApplicationUtils.updateProcessingOptionsMap(this.m_poMap, processingEle);
            this.m_poEle = ApplicationUtils.createProcessingOptionsElement(this.m_poMap);
            XTSApplicationManager.getInstance().getProcessingOptionsMap().setProcessingOptions(this.m_interfacePath, this.m_poEle);
        }
    }
}

