/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.request.XTSRequestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XTSInterfaceInfo {
    public static final String INTERFACES_ROOT = "interfaces";
    private String m_sPathInfo;
    private String m_sVirtualPath;
    private String m_sExtraPath;
    private String m_sPhysicalPath;
    private String m_sMorphlet;
    private String m_sInterfaceName;
    private XTSInterface m_oInterface;

    public static XTSInterfaceInfo checkOldStyleInterfaceCall(String pathInfo) {
        int lastSlashIndex = pathInfo.lastIndexOf("/");
        if (lastSlashIndex == 0 || lastSlashIndex == pathInfo.length()) {
            return null;
        }
        String operationName = pathInfo.substring(lastSlashIndex + 1);
        String lastSlashSubstring = pathInfo.substring(0, lastSlashIndex);
        int pathSlashIndex = lastSlashSubstring.lastIndexOf("/");
        if (pathSlashIndex == -1) {
            return null;
        }
        String interfaceName = lastSlashSubstring.substring(pathSlashIndex + 1, lastSlashIndex);
        String virtualPath = lastSlashSubstring.substring(0, pathSlashIndex);
        XTSInterface iface = XTSApplicationManager.getInstance().getInterfaceByName(virtualPath + "/", interfaceName);
        if (iface == null) {
            return null;
        }
        XTSInterfaceInfo iInfo = new XTSInterfaceInfo();
        iInfo.m_sPathInfo = pathInfo;
        if (iInfo.m_sPathInfo.endsWith("/")) {
            iInfo.m_sPathInfo = iInfo.m_sPathInfo.substring(0, iInfo.m_sPathInfo.length() - "/".length());
        }
        iInfo.m_sVirtualPath = virtualPath;
        if (iInfo.m_sVirtualPath.endsWith("/")) {
            iInfo.m_sVirtualPath = iInfo.m_sVirtualPath.substring(0, iInfo.m_sVirtualPath.length() - "/".length());
        }
        iInfo.m_sExtraPath = "/" + interfaceName + "/" + operationName;
        if (iInfo.m_sExtraPath.endsWith("/")) {
            iInfo.m_sExtraPath = iInfo.m_sExtraPath.substring(0, iInfo.m_sExtraPath.length() - "/".length());
        }
        iInfo.m_sPhysicalPath = iface.getInterfacePath();
        if (iInfo.m_sPhysicalPath.endsWith("/")) {
            iInfo.m_sPhysicalPath = iInfo.m_sPhysicalPath.substring(0, iInfo.m_sPhysicalPath.length() - "/".length());
        }
        iInfo.m_sMorphlet = iface.getMorphlet(operationName);
        iInfo.m_oInterface = iface;
        iInfo.m_sInterfaceName = iface.getInterfaceName();
        return iInfo;
    }

    public static XTSInterfaceInfo checkOldStyleInterfaceCall(String pathInfo, String ns, String operation) {
        XTSInterface iface;
        String curPath = pathInfo;
        if (!curPath.endsWith("/")) {
            curPath = curPath + "/";
        }
        if ((iface = XTSApplicationManager.getInstance().getInterfaceByNS(curPath, ns)) == null) {
            return null;
        }
        XTSInterfaceInfo iInfo = new XTSInterfaceInfo();
        iInfo.m_sPathInfo = pathInfo;
        if (iInfo.m_sPathInfo.endsWith("/")) {
            iInfo.m_sPathInfo = iInfo.m_sPathInfo.substring(0, iInfo.m_sPathInfo.length() - "/".length());
        }
        iInfo.m_sVirtualPath = pathInfo;
        if (iInfo.m_sVirtualPath.endsWith("/")) {
            iInfo.m_sVirtualPath = iInfo.m_sVirtualPath.substring(0, iInfo.m_sVirtualPath.length() - "/".length());
        }
        iInfo.m_sExtraPath = "";
        iInfo.m_sPhysicalPath = iface.getInterfacePath();
        if (iInfo.m_sPhysicalPath.endsWith("/")) {
            iInfo.m_sPhysicalPath = iInfo.m_sPhysicalPath.substring(0, iInfo.m_sPhysicalPath.length() - "/".length());
        }
        iInfo.m_sMorphlet = iface.getMorphlet(operation);
        iInfo.m_oInterface = iface;
        iInfo.m_sInterfaceName = iface.getInterfaceName();
        return iInfo;
    }

    public static List searchInterfaceInfo(String pathInfo) {
        String curPath = pathInfo;
        if (!curPath.endsWith("/")) {
            curPath = curPath + "/";
        }
        List ifaces = null;
        int idx = curPath.length() - 1;
        while (idx >= 0 && (ifaces = XTSApplicationManager.getInstance().searchInterface(curPath.substring(0, idx + "/".length()))).size() <= 0) {
            idx = curPath.lastIndexOf("/", idx - "/".length());
        }
        if (ifaces == null || ifaces.size() == 0) {
            return new ArrayList();
        }
        ArrayList<XTSInterfaceInfo> iInfoList = new ArrayList<XTSInterfaceInfo>(ifaces.size());
        for (int i = 0; i < ifaces.size(); ++i) {
            XTSInterface iface = (XTSInterface)ifaces.get(i);
            XTSInterfaceInfo iInfo = new XTSInterfaceInfo();
            iInfo.m_sPathInfo = pathInfo;
            if (iInfo.m_sPathInfo.endsWith("/")) {
                iInfo.m_sPathInfo = iInfo.m_sPathInfo.substring(0, iInfo.m_sPathInfo.length() - "/".length());
            }
            iInfo.m_sVirtualPath = curPath.substring(0, idx);
            if (iInfo.m_sVirtualPath.endsWith("/")) {
                iInfo.m_sVirtualPath = iInfo.m_sVirtualPath.substring(0, iInfo.m_sVirtualPath.length() - "/".length());
            }
            iInfo.m_sExtraPath = curPath.substring(idx);
            if (iInfo.m_sExtraPath.endsWith("/")) {
                iInfo.m_sExtraPath = iInfo.m_sExtraPath.substring(0, iInfo.m_sExtraPath.length() - "/".length());
            }
            iInfo.m_sPhysicalPath = iface.getInterfacePath();
            if (iInfo.m_sPhysicalPath.endsWith("/")) {
                iInfo.m_sPhysicalPath = iInfo.m_sPhysicalPath.substring(0, iInfo.m_sPhysicalPath.length() - "/".length());
            }
            iInfo.m_oInterface = iface;
            iInfo.m_sInterfaceName = iface.getInterfaceName();
            String morphlet = null;
            Element processingElement = iface.getProcessingOptions();
            if (processingElement != null) {
                List paramList = processingElement.elements("param");
                for (int j = 0; j < paramList.size(); ++j) {
                    Element paramEle = (Element)paramList.get(j);
                    String att = paramEle.attributeValue("name");
                    if (att == null || !att.equals("WSGetHandler")) continue;
                    morphlet = paramEle.getTextTrim();
                    break;
                }
            }
            iInfo.m_sMorphlet = morphlet;
            iInfoList.add(iInfo);
        }
        return iInfoList;
    }

    public static XTSInterfaceInfo searchInterfaceInfo(String pathInfo, String ns, String operation) {
        String curPath = pathInfo;
        if (!curPath.endsWith("/")) {
            curPath = curPath + "/";
        }
        XTSInterface result = null;
        int idx = curPath.length() - 1;
        while (idx >= 0) {
            XTSInterface iface = XTSApplicationManager.getInstance().getInterfaceByNS(curPath.substring(0, idx + "/".length()), ns);
            if (iface != null) {
                HashMap opMap = new HashMap();
                iface.getOperations(opMap);
                if (opMap.containsKey(operation)) {
                    result = iface;
                    break;
                }
            }
            idx = curPath.lastIndexOf("/", idx - "/".length());
        }
        if (result == null) {
            return null;
        }
        XTSInterfaceInfo iInfo = new XTSInterfaceInfo();
        iInfo.m_sPathInfo = pathInfo;
        if (iInfo.m_sPathInfo.endsWith("/")) {
            iInfo.m_sPathInfo = iInfo.m_sPathInfo.substring(0, iInfo.m_sPathInfo.length() - "/".length());
        }
        iInfo.m_sVirtualPath = curPath.substring(0, idx);
        if (iInfo.m_sVirtualPath.endsWith("/")) {
            iInfo.m_sVirtualPath = iInfo.m_sVirtualPath.substring(0, iInfo.m_sVirtualPath.length() - "/".length());
        }
        iInfo.m_sExtraPath = curPath.substring(idx);
        if (iInfo.m_sExtraPath.endsWith("/")) {
            iInfo.m_sExtraPath = iInfo.m_sExtraPath.substring(0, iInfo.m_sExtraPath.length() - "/".length());
        }
        iInfo.m_sPhysicalPath = result.getInterfacePath();
        if (iInfo.m_sPhysicalPath.endsWith("/")) {
            iInfo.m_sPhysicalPath = iInfo.m_sPhysicalPath.substring(0, iInfo.m_sPhysicalPath.length() - "/".length());
        }
        iInfo.m_oInterface = result;
        iInfo.m_sInterfaceName = result.getInterfaceName();
        iInfo.m_sMorphlet = result.getMorphlet(operation);
        return iInfo;
    }

    public static boolean interfaceExists(String pathInfo, String ns) {
        String curPath = pathInfo;
        if (!curPath.endsWith("/")) {
            curPath = curPath + "/";
        }
        int idx = curPath.length() - 1;
        while (idx >= 0) {
            XTSInterface iface = XTSApplicationManager.getInstance().getInterfaceByNS(curPath.substring(0, idx + "/".length()), ns);
            if (iface != null) {
                return true;
            }
            idx = curPath.lastIndexOf("/", idx - "/".length());
        }
        return false;
    }

    private XTSInterfaceInfo() {
    }

    public String getPathInfo() {
        return this.m_sPathInfo;
    }

    public String getVirtualPath() {
        return this.m_sVirtualPath;
    }

    public String getExtraPath() {
        return this.m_sExtraPath;
    }

    public String getPhysicalPath() {
        return this.m_sPhysicalPath;
    }

    public String getMorphlet() {
        return this.m_sMorphlet;
    }

    public String getInterfaceName() {
        return this.m_sInterfaceName;
    }

    public XTSInterface getXTSInterface() {
        return this.m_oInterface;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("<interfaceInfo>");
        ret.append("<param name=\"pathInfo\">").append(this.m_sPathInfo == null ? "" : this.m_sPathInfo).append("</param>");
        ret.append("<param name=\"virtualPath\">").append(this.m_sVirtualPath == null ? "" : this.m_sVirtualPath).append("</param>");
        ret.append("<param name=\"extraInfo\">").append(this.m_sExtraPath == null ? "" : this.m_sExtraPath).append("</param>");
        ret.append("<param name=\"location\">").append(this.m_sPhysicalPath == null ? "" : this.m_sPhysicalPath).append("</param>");
        ret.append("<param name=\"morphlet\">").append(this.m_sMorphlet == null ? "" : this.m_sMorphlet).append("</param>");
        ret.append("<param name=\"name\">").append(this.m_sInterfaceName == null ? "" : this.m_sInterfaceName).append("</param>");
        ret.append("</interfaceInfo>");
        return ret.toString();
    }

    public Element toElement() {
        Element infoEle = DocumentHelper.createElement((String)"interfaceInfo");
        infoEle.add(XTSRequestUtil.createParamElement("pathInfo", this.m_sPathInfo == null ? "" : this.m_sPathInfo));
        infoEle.add(XTSRequestUtil.createParamElement("virtualPath", this.m_sVirtualPath == null ? "" : this.m_sVirtualPath));
        infoEle.add(XTSRequestUtil.createParamElement("extraInfo", this.m_sExtraPath == null ? "" : this.m_sExtraPath));
        infoEle.add(XTSRequestUtil.createParamElement("location", this.m_sPhysicalPath == null ? "" : this.m_sPhysicalPath));
        infoEle.add(XTSRequestUtil.createParamElement("morphlet", this.m_sMorphlet == null ? "" : this.m_sMorphlet));
        infoEle.add(XTSRequestUtil.createParamElement("name", this.m_sInterfaceName == null ? "" : this.m_sInterfaceName));
        return infoEle;
    }
}

