/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.XTSException;
import com.cognos.xts.application.XTSInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class XTSInterfaceMap {
    private HashMap m_interfaceMapByName = new HashMap();
    private HashMap m_interfaceMapByNS = new HashMap();
    private Object m_mutex = new Object();

    public void setInterfaceByName(String vPath, String iName, XTSInterface oface) throws XTSException {
        this.setInterface(vPath, iName, oface, this.m_interfaceMapByName);
    }

    public void setInterfaceByNS(String vPath, String ns, XTSInterface oface) throws XTSException {
        this.setInterface(vPath, ns, oface, this.m_interfaceMapByNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterface(String vPath, String id, XTSInterface oface, HashMap map) throws XTSException {
        if (vPath == null || id == null || oface == null) {
            return;
        }
        String key = "[" + vPath + "][" + id + "]";
        Object object = this.m_mutex;
        synchronized (object) {
            if (map.containsKey(key)) {
                XTSInterface iExistingInterface = (XTSInterface)map.get(key);
                if (iExistingInterface.getInterfacePath().startsWith(oface.getInterfacePath())) {
                    oface.merge(iExistingInterface);
                } else if (oface.getInterfacePath().startsWith(iExistingInterface.getInterfacePath())) {
                    iExistingInterface.merge(oface);
                } else {
                    iExistingInterface.merge(oface);
                }
            } else {
                map.put(key, oface);
            }
        }
    }

    public XTSInterface getInterfaceByName(String vPath, String iName) {
        return this.getInterface(vPath, iName, this.m_interfaceMapByName);
    }

    public XTSInterface getInterfaceByNS(String vPath, String ns) {
        return this.getInterface(vPath, ns, this.m_interfaceMapByNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XTSInterface getInterface(String vPath, String iName, HashMap map) {
        if (vPath == null || iName == null) {
            return null;
        }
        String key = "[" + vPath + "][" + iName + "]";
        XTSInterface iface = null;
        Object object = this.m_mutex;
        synchronized (object) {
            iface = (XTSInterface)map.get(key);
        }
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchInterfaceByVPath(String vPath) {
        ArrayList ret = new ArrayList();
        if (vPath == null) {
            return ret;
        }
        String key = "[" + vPath + "]";
        Object object = this.m_mutex;
        synchronized (object) {
            Set keys = this.m_interfaceMapByName.keySet();
            for (String mapkey : keys) {
                if (!mapkey.startsWith(key)) continue;
                ret.add(this.m_interfaceMapByName.get(mapkey));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMap() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_interfaceMapByName = new HashMap();
            this.m_interfaceMapByNS = new HashMap();
        }
    }

    public void dump() {
        System.out.println("InterfaceMapByName: ");
        System.out.println(this.m_interfaceMapByName.toString());
        System.out.println("InterfaceMapByNS: ");
        System.out.println(this.m_interfaceMapByNS.toString());
    }
}

