/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.application;

import com.cognos.xts.XTSException;
import com.cognos.xts.application.ApplicationUtils;
import com.cognos.xts.application.XTSApplication;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.PathUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class XTSRoot {
    private static final String ROOT_TAG = "root";
    private static final String OPTION_FILE = "system.xml";
    private static final String CONFIG_FILE = "root.xml";

    public static void parse(DirEnt root) throws XTSException {
        double curVersion;
        block14: {
            if (root == null) {
                return;
            }
            curVersion = 0.0;
            try {
                String sSystemXMLVersion = PropertiesManager.getInstance().getProperty("systemxml.version");
                curVersion = Double.parseDouble(sSystemXMLVersion);
            }
            catch (Exception e) {
                curVersion = 0.0;
                IXTSLogger traceLogger1 = null;
                if (!XTSTraceLoggerManager.getInstance().isEnabled[0][0] || (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) == null) break block14;
                StringBuffer msg = new StringBuffer();
                msg.append("Invalid systemxml.version in xts.properties file.\n");
                traceLogger1.log(null, 8, msg.toString(), null, null);
            }
        }
        HashMap soMap = new HashMap();
        try {
            String optionFile = PathUtils.buildPath(root.getPath(), OPTION_FILE);
            Element sysEle = ApplicationUtils.readFile(optionFile);
            if (sysEle != null) {
                if (!sysEle.getName().equals("system")) {
                    throw new XTSException("application.invalidsystemxml");
                }
                sysEle = ApplicationUtils.upgradeSystem(optionFile, sysEle, curVersion);
                ApplicationUtils.updateSystemOptionsMap(soMap, sysEle);
            }
        }
        catch (IOException e) {
            throw new XTSException("application.invalidsystemxml", e);
        }
        Element resultSysEle = ApplicationUtils.createSystemElement(soMap);
        XTSApplicationManager.getInstance().getSystemOptionsMap().setSystemOptions("", resultSysEle);
        HashMap poMap = new HashMap();
        try {
            String configFile = PathUtils.buildPath(root.getPath(), CONFIG_FILE);
            Element configEle = ApplicationUtils.readFile(configFile);
            if (configEle != null) {
                if (!configEle.getName().equals(ROOT_TAG)) {
                    throw new XTSException("application.invalidrootxml");
                }
                Element poEle = configEle.element("processing");
                if (poEle != null) {
                    ApplicationUtils.updateProcessingOptionsMap(poMap, poEle);
                }
            }
        }
        catch (IOException e) {
            throw new XTSException("application.invalidprocessingxml", e);
        }
        Element resultPoEle = ApplicationUtils.createProcessingOptionsElement(poMap);
        XTSApplicationManager.getInstance().getProcessingOptionsMap().setProcessingOptions("", resultPoEle);
        List apps = root.getChildren();
        if (apps != null) {
            for (int i = 0; i < apps.size(); ++i) {
                DirEnt app = (DirEnt)apps.get(i);
                XTSApplication.parse(app, soMap, poMap, curVersion);
            }
        }
    }
}

