/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic;

import com.cognos.xts.XTSException;
import com.cognos.xts.capability.XTSCapabilityBusException;
import com.cognos.xts.interpreter.instructions.XTSFaultException;
import com.cognos.xts.interpreter.instructions.request.XTSBusException;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.soaputil;
import java.util.List;
import java.util.Locale;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public final class UXTSBusExceptionUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final Namespace BUS_NAMESPACE = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    private static final QName BUS_EXCEPTION_QNAME = new QName("exception", BUS_NAMESPACE);
    private static final QName BUS_MESSAGE_QNAME = new QName("message", BUS_NAMESPACE);
    private static final String BUS_SERVERITY = "severity";
    private static final String BUS_FATAL = "fatal";
    private static final String BUS_ERROR = "error";
    private static final String BUS_WARNING = "warning";
    private static final String BUS_INFORMATION = "information";
    private static final String BUS_ERRORCODE = "errorCode";
    private static final String BUS_MESSAGESTRING = "messageString";
    private static final String BUS_MESSAGEDETAIL = "messageDetail";

    public static Element convertXTSExceptionToBusFault(XTSException e, int soapVersion, Locale locale) {
        boolean debug = false;
        String sDebugEnable = PropertiesManager.getInstance().getProperty("option.fullexceptionlist");
        if (sDebugEnable != null && sDebugEnable.equals("true")) {
            debug = true;
        }
        XTSException curEx = e;
        if (!debug) {
            Throwable nextEx = e.getDetail();
            while (nextEx != null && nextEx instanceof XTSException) {
                curEx = (XTSException)nextEx;
                nextEx = ((XTSException)nextEx).getDetail();
            }
        }
        Element soapEnvEle = curEx.getSoapEnvElementCopy(locale, soapVersion);
        if (curEx instanceof XTSBusException) {
            return soapEnvEle;
        }
        if (curEx instanceof XTSCapabilityBusException) {
            return soapEnvEle;
        }
        if (curEx instanceof XTSSoapFaultException) {
            return UXTSBusExceptionUtils.convertSoapDetailToBusDetail(soapEnvEle, locale, soapVersion, "XTS-SF");
        }
        if (curEx instanceof XTSFaultException) {
            return UXTSBusExceptionUtils.convertSoapDetailToBusDetail(soapEnvEle, locale, soapVersion, "XTS-UDF");
        }
        return UXTSBusExceptionUtils.convertXTSDetailToBusDetail(soapEnvEle, locale, soapVersion, "XTS-EF");
    }

    private static Element convertSoapDetailToBusDetail(Element soapEnvEle, Locale locale, int soapVer, String errorCode) {
        String faultString;
        Element soapDetailEle;
        Element soapFaultEle;
        Element soapBodyEle;
        if (soapEnvEle == null) {
            soapEnvEle = soaputil.createSOAPEnvelope(soapVer, null, null);
        }
        if ((soapBodyEle = soapEnvEle.element("Body")) == null) {
            soapBodyEle = soaputil.createSOAPBody(soapVer);
            soapEnvEle.add(soapBodyEle);
        }
        if ((soapFaultEle = soapBodyEle.element("Fault")) == null) {
            String code = "soap.invalidfault";
            String message2 = MessagesManager.getInstance().getMessage(locale, code);
            soapFaultEle = soaputil.createSOAPFault(soapVer, code, message2, null);
            soapBodyEle.add(soapFaultEle);
        }
        if ((soapDetailEle = soapFaultEle.element("detail")) != null) {
            soapDetailEle.detach();
        }
        Element newSoapDetailEle = soaputil.createSOAPFaultDetail(soapVer);
        soapFaultEle.add(newSoapDetailEle);
        Element busExEle = DocumentHelper.createElement((QName)BUS_EXCEPTION_QNAME);
        newSoapDetailEle.add(busExEle);
        Element severityEle = DocumentHelper.createElement((String)BUS_SERVERITY);
        severityEle.addText(BUS_ERROR);
        busExEle.add(severityEle);
        Element errorCodeEle = DocumentHelper.createElement((String)BUS_ERRORCODE);
        if (errorCode != null) {
            errorCodeEle.addText(errorCode);
        }
        busExEle.add(errorCodeEle);
        Element busMsgEle = DocumentHelper.createElement((QName)BUS_MESSAGE_QNAME);
        busExEle.add(busMsgEle);
        Element busMsgStrEle = DocumentHelper.createElement((String)BUS_MESSAGESTRING);
        Element soapFaultStringEle = soapFaultEle.element("faultstring");
        if (soapFaultStringEle != null && (faultString = soapFaultStringEle.getTextTrim()) != null) {
            busMsgStrEle.addText(faultString);
        }
        busMsgEle.add(busMsgStrEle);
        if (soapDetailEle != null) {
            Element busMsgDetailEle = DocumentHelper.createElement((String)BUS_MESSAGEDETAIL);
            busMsgDetailEle.appendContent((Branch)soapDetailEle);
            busMsgEle.add(busMsgDetailEle);
        }
        return soapEnvEle;
    }

    private static Element convertXTSDetailToBusDetail(Element soapEnvEle, Locale locale, int soapVer, String errorCode) {
        Element soapFaultEle = soapEnvEle.element("Body").element("Fault");
        if (soapFaultEle == null) {
            return soapEnvEle;
        }
        Element soapDetailEle = soapFaultEle.element("detail");
        if (soapDetailEle == null) {
            return soapEnvEle;
        }
        soapDetailEle.detach();
        Element newSoapDetailEle = DocumentHelper.createElement((String)"detail");
        soapFaultEle.add(newSoapDetailEle);
        Element busExEle = DocumentHelper.createElement((QName)BUS_EXCEPTION_QNAME);
        newSoapDetailEle.add(busExEle);
        Element severityEle = DocumentHelper.createElement((String)BUS_SERVERITY);
        severityEle.addText(BUS_ERROR);
        busExEle.add(severityEle);
        Element errorCodeEle = DocumentHelper.createElement((String)BUS_ERRORCODE);
        String xtsCode = null;
        Element soapFaultStringEle = soapFaultEle.element("faultstring");
        if (soapFaultStringEle != null && (xtsCode = soapFaultStringEle.getTextTrim()) != null) {
            int idx = xtsCode.indexOf(32);
            if (idx != -1) {
                xtsCode = xtsCode.substring(0, idx);
            }
            if ((idx = xtsCode.lastIndexOf(45)) != -1) {
                xtsCode = xtsCode.substring(0, idx);
            }
        }
        if (xtsCode != null && xtsCode.length() > 0) {
            errorCodeEle.addText(xtsCode);
        } else if (errorCode != null) {
            errorCodeEle.addText(errorCode);
        }
        busExEle.add(errorCodeEle);
        List xtsExList = soapDetailEle.elements(XTSException.EXCEPTION_QNAME);
        for (int i = 0; i < xtsExList.size(); ++i) {
            String xtsExMsgStr;
            Element xtsEx = (Element)xtsExList.get(i);
            Element busMsgEle = DocumentHelper.createElement((QName)BUS_MESSAGE_QNAME);
            busExEle.add(busMsgEle);
            Element busMsgStrEle = DocumentHelper.createElement((String)BUS_MESSAGESTRING);
            Element xtsExMsg = xtsEx.element(XTSException.EXCEPTIONMSG_QNAME);
            if (xtsExMsg != null && (xtsExMsgStr = xtsExMsg.getText()) != null) {
                busMsgStrEle.addText(xtsExMsgStr);
            }
            busMsgEle.add(busMsgStrEle);
        }
        return soapEnvEle;
    }
}

