/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.configuration;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.i18n.CollationKey;
import com.cognos.i18n.Collator;
import com.cognos.i18n.TimeZone;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.util.LocaleUtils;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CCLConfig
implements IXTSConfiguration {
    private static final String SERVER_LOCALE = "serverLocale";
    private static final String SERVER_TIMEZONEID = "serverTimeZoneID";
    private static final String DISP_PROP = "internalDispatcher";
    private static final String CM_PROP = "contentManager";
    private static final String ADVANCED_SETTINGS = "advancedSettings";
    private static final String DISP_HOST = "dispatcher.host";
    private static final String DISP_PORT = "dispatcher.port";
    private static final String DISP_PATH = "dispatcher.url";
    private static final String DISP_SECURE = "dispatcher.secure";
    private static final String CM_HOST = "cm.host";
    private static final String CM_PORT = "cm.port";
    private static final String CM_PATH = "cm.url";
    private static final String CM_SECURE = "cm.secure";
    private ICCLConfiguration m_oConfig;
    private String m_sServerLocale;
    private String m_sServerTimeZoneID;
    private String m_sDispProp;
    private String m_sCMProp;
    private Properties m_advancedSettings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CCLConfig(ICCLConfiguration config) {
        block16: {
            this.m_oConfig = null;
            this.m_sServerLocale = null;
            this.m_sServerTimeZoneID = null;
            this.m_sDispProp = null;
            this.m_sCMProp = null;
            this.m_advancedSettings = new Properties();
            this.m_oConfig = config;
            try {
                this.m_sServerLocale = this.m_oConfig.getValue(SERVER_LOCALE, false);
            }
            catch (CCLConfigurationException e) {
                this.m_sServerLocale = null;
            }
            try {
                this.m_sServerTimeZoneID = this.m_oConfig.getValue(SERVER_TIMEZONEID, false);
            }
            catch (CCLConfigurationException e) {
                this.m_sServerTimeZoneID = null;
            }
            try {
                this.m_sDispProp = this.m_oConfig.getValue(DISP_PROP, true);
            }
            catch (CCLConfigurationException e) {
                this.m_sDispProp = null;
            }
            try {
                this.m_sCMProp = this.m_oConfig.getValue(CM_PROP, true);
            }
            catch (CCLConfigurationException e) {
                this.m_sCMProp = null;
            }
            try {
                String settings;
                Element advancedSettingsElement = this.m_oConfig.getValueElement(ADVANCED_SETTINGS, true);
                if (advancedSettingsElement == null || (settings = advancedSettingsElement.getText()) == null) break block16;
                StringReader resultReader = new StringReader(settings);
                AXTSPoolObject reader = XTSSAXReaderPool.getInstance().acquire();
                try {
                    Element settingsElement = ((SAXReader)reader.get()).read((Reader)resultReader).getRootElement();
                    Iterator it = settingsElement.elementIterator("setting");
                    while (it.hasNext()) {
                        Element settingElement = (Element)it.next();
                        String name = settingElement.attributeValue("name");
                        String value = settingElement.getText();
                        if (name == null) continue;
                        this.m_advancedSettings.put(name, value);
                    }
                }
                finally {
                    XTSSAXReaderPool.getInstance().put(reader);
                }
            }
            catch (XTSException e) {
                this.m_advancedSettings.clear();
            }
            catch (DocumentException e) {
                this.m_advancedSettings.clear();
            }
            catch (CCLConfigurationException e) {
                this.m_advancedSettings.clear();
            }
        }
    }

    private Map sort(Locale locale, Map map) {
        Collator collator = new Collator(locale);
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry pair : map.entrySet()) {
            String name = (String)pair.getValue();
            CollationKey key = collator.getCollationKey(name);
            sortedMap.put(key, pair);
        }
        return sortedMap;
    }

    @Override
    public Element getConfigInfo(Locale locale) throws XTSConfigurationException {
        try {
            Element configInfo = DocumentHelper.createElement((String)"config");
            Element paramElem = DocumentHelper.createElement((String)"param");
            paramElem.addAttribute("name", "locale");
            configInfo.add(paramElem);
            String sServerLocale = this.m_sServerLocale;
            if (sServerLocale != null) {
                Element ele = DocumentHelper.createElement((String)"locale");
                ele.addAttribute("type", SERVER_LOCALE);
                Element id = DocumentHelper.createElement((String)"id");
                id.addText(sServerLocale);
                ele.add(id);
                String lang = "";
                String country = "";
                int idx = sServerLocale.indexOf(45);
                if (idx == -1) {
                    lang = sServerLocale;
                } else {
                    lang = sServerLocale.substring(0, idx);
                    country = sServerLocale.substring(idx + 1);
                }
                Locale sl = new Locale(lang, country);
                Element name = DocumentHelper.createElement((String)"displayName");
                String slDisplayName = sl.getDisplayName(locale);
                if (slDisplayName != null) {
                    name.addText(slDisplayName);
                }
                ele.add(name);
                paramElem.add(ele);
            }
            this.addContentLocalesElement(locale, paramElem);
            this.addProductLocalesElement(locale, paramElem);
            paramElem = DocumentHelper.createElement((String)"param");
            paramElem.addAttribute("name", "timezone");
            configInfo.add(paramElem);
            String sServerTimeZone = this.m_sServerTimeZoneID;
            if (sServerTimeZone != null) {
                Element ele = DocumentHelper.createElement((String)"timezone");
                ele.addAttribute("type", "serverTimeZone");
                Element id = DocumentHelper.createElement((String)"id");
                id.addText(sServerTimeZone);
                ele.add(id);
                TimeZone tz = new TimeZone(sServerTimeZone);
                Element name = DocumentHelper.createElement((String)"displayName");
                String tzDisplayName = tz.getDisplayName(locale);
                if (tzDisplayName != null) {
                    name.addText(tzDisplayName);
                }
                ele.add(name);
                paramElem.add(ele);
            }
            this.addTimeZonesElement(locale, paramElem);
            return configInfo;
        }
        catch (CCLConfigurationException e) {
            throw new XTSConfigurationException("cclconfig.getinfofailed", e);
        }
    }

    @Override
    public String getPhysicalPath(String path) throws XTSConfigurationException {
        try {
            return this.m_oConfig.resolveEffectivePath(path);
        }
        catch (Exception e) {
            Object[] args = new String[]{path};
            throw new XTSConfigurationException("cclconfig.getpathfailed", args, e);
        }
    }

    @Override
    public boolean validateContentLocale(Locale locale) throws XTSConfigurationException {
        try {
            return this.m_oConfig.validateContentLocale(LocaleUtils.toNormalizedString(locale));
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{LocaleUtils.toNormalizedString(locale)};
            throw new XTSConfigurationException("cclconfig.validateContentLocale", args, e);
        }
    }

    @Override
    public boolean validateProductLocale(Locale locale) throws XTSConfigurationException {
        try {
            return this.m_oConfig.validateProductLocale(LocaleUtils.toNormalizedString(locale));
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{LocaleUtils.toNormalizedString(locale)};
            throw new XTSConfigurationException("cclconfig.validateProductLocale", args, e);
        }
    }

    @Override
    public Locale mapContentLocale(Locale locale) throws XTSConfigurationException {
        try {
            String ret = this.m_oConfig.mapContentLocale(LocaleUtils.toNormalizedString(locale), false);
            return LocaleUtils.toLocale(ret);
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    @Override
    public Locale mapProductLocale(Locale locale) throws XTSConfigurationException {
        try {
            String ret = this.m_oConfig.mapProductLocale(LocaleUtils.toNormalizedString(locale), false);
            return LocaleUtils.toLocale(ret);
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    @Override
    public Locale getServerLocale() throws XTSConfigurationException {
        return LocaleUtils.toLocale(this.m_sServerLocale);
    }

    @Override
    public String getComponentVersion(String name) throws XTSConfigurationException {
        try {
            return this.m_oConfig.getComponentVersion(name);
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{name};
            throw new XTSConfigurationException("cclconfig.getComponentVersion", args, e);
        }
    }

    @Override
    public String getProperty(String name) throws XTSConfigurationException {
        String value = this.m_advancedSettings.getProperty(name);
        if (value != null) {
            return value;
        }
        try {
            return this.m_oConfig.getValue(name, true);
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{name};
            throw new XTSConfigurationException("cclconfig.getpropfailed", args, e);
        }
    }

    @Override
    public String getProductLocalesProperty(Locale locale) throws XTSConfigurationException {
        try {
            Element paramElem = DocumentHelper.createElement((String)"property");
            paramElem.addAttribute("name", "productLocales");
            this.addProductLocalesElement(locale, paramElem);
            return paramElem.asXML();
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{"productLocales"};
            throw new XTSConfigurationException("cclconfig.getpropfailed", args, e);
        }
    }

    @Override
    public String getContentLocalesProperty(Locale locale) throws XTSConfigurationException {
        try {
            Element paramElem = DocumentHelper.createElement((String)"property");
            paramElem.addAttribute("name", "contentLocales");
            this.addContentLocalesElement(locale, paramElem);
            return paramElem.asXML();
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{"contentLocales"};
            throw new XTSConfigurationException("cclconfig.getpropfailed", args, e);
        }
    }

    @Override
    public String getTimeZonesProperty(Locale locale) throws XTSConfigurationException {
        try {
            Element paramElem = DocumentHelper.createElement((String)"property");
            paramElem.addAttribute("name", "timeZones");
            this.addTimeZonesElement(locale, paramElem);
            return paramElem.asXML();
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{"timeZones"};
            throw new XTSConfigurationException("cclconfig.getpropfailed", args, e);
        }
    }

    @Override
    public String getFontsProperty(Locale locale) throws XTSConfigurationException {
        try {
            Element paramElem = DocumentHelper.createElement((String)"property");
            paramElem.addAttribute("name", "fonts");
            List flist = this.m_oConfig.getFonts(LocaleUtils.toNormalizedString(locale));
            if (flist != null) {
                Iterator it = flist.iterator();
                while (it.hasNext()) {
                    Element ele = DocumentHelper.createElement((String)"font");
                    Element id = DocumentHelper.createElement((String)"id");
                    id.addText((String)it.next());
                    ele.add(id);
                    paramElem.add(ele);
                }
            }
            return paramElem.asXML();
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{"fonts"};
            throw new XTSConfigurationException("cclconfig.getpropfailed", args, e);
        }
    }

    @Override
    public String getCurrenciesProperty(Locale locale) throws XTSConfigurationException {
        try {
            Element paramElem = DocumentHelper.createElement((String)"property");
            paramElem.addAttribute("name", "currencies");
            Map cmap = this.m_oConfig.getCurrencies(LocaleUtils.toNormalizedString(locale));
            if (cmap != null) {
                Map sortedMap = this.sort(locale, cmap);
                for (Map.Entry pair : sortedMap.values()) {
                    Element ele = DocumentHelper.createElement((String)"currency");
                    Element id = DocumentHelper.createElement((String)"id");
                    id.addText((String)pair.getKey());
                    ele.add(id);
                    Element name = DocumentHelper.createElement((String)"displayName");
                    String value = (String)pair.getValue();
                    if (value != null) {
                        name.addText(value);
                    }
                    ele.add(name);
                    paramElem.add(ele);
                }
            }
            return paramElem.asXML();
        }
        catch (CCLConfigurationException e) {
            Object[] args = new String[]{"currencies"};
            throw new XTSConfigurationException("cclconfig.getpropfailed", args, e);
        }
    }

    @Override
    public Properties getProperties() throws XTSConfigurationException {
        String cmProp;
        Properties prop = new Properties(this.m_advancedSettings);
        String dispProp = this.m_sDispProp;
        if (dispProp != null && dispProp.length() > 0) {
            URL disp = null;
            try {
                disp = new URL(dispProp);
            }
            catch (MalformedURLException e) {
                Object[] args = new String[]{dispProp, DISP_PROP};
                throw new XTSConfigurationException("property.malformedURL", args, e);
            }
            prop.setProperty(DISP_HOST, disp.getHost());
            prop.setProperty(DISP_PORT, Integer.toString(disp.getPort()));
            prop.setProperty(DISP_PATH, disp.getPath());
            if (disp.getProtocol().equals("https")) {
                prop.setProperty(DISP_SECURE, "true");
            } else {
                prop.setProperty(DISP_SECURE, "false");
            }
        }
        if ((cmProp = this.m_sCMProp) != null && cmProp.length() > 0) {
            URL cm = null;
            try {
                cm = new URL(cmProp);
            }
            catch (MalformedURLException e) {
                Object[] args = new String[]{cmProp, CM_PROP};
                throw new XTSConfigurationException("property.malformedURL", args, e);
            }
            prop.setProperty(CM_HOST, cm.getHost());
            prop.setProperty(CM_PORT, Integer.toString(cm.getPort()));
            prop.setProperty(CM_PATH, cm.getPath());
            if (cm.getProtocol().equals("https")) {
                prop.setProperty(CM_SECURE, "true");
            } else {
                prop.setProperty(CM_SECURE, "false");
            }
        }
        return prop;
    }

    @Override
    public boolean equals(IXTSConfiguration config) throws XTSConfigurationException {
        if (config == null || !(config instanceof CCLConfig)) {
            return false;
        }
        CCLConfig newConfig = (CCLConfig)config;
        if (this.m_sServerLocale == null || newConfig.m_sServerLocale == null || !this.m_sServerLocale.equals(newConfig.m_sServerLocale)) {
            return false;
        }
        if (this.m_sServerTimeZoneID == null || newConfig.m_sServerTimeZoneID == null || !this.m_sServerTimeZoneID.equals(newConfig.m_sServerTimeZoneID)) {
            return false;
        }
        if (this.m_sDispProp == null || newConfig.m_sDispProp == null || !this.m_sDispProp.equals(newConfig.m_sDispProp)) {
            return false;
        }
        return this.m_sCMProp != null && newConfig.m_sCMProp != null && this.m_sCMProp.equals(newConfig.m_sCMProp);
    }

    private void addContentLocalesElement(Locale locale, Element paramElem) throws CCLConfigurationException {
        Map clmap = this.m_oConfig.getContentLocaleList(LocaleUtils.toNormalizedString(locale));
        if (clmap != null) {
            Map sortedMap = this.sort(locale, clmap);
            for (Map.Entry pair : sortedMap.values()) {
                Element ele = DocumentHelper.createElement((String)"locale");
                ele.addAttribute("type", "contentLocale");
                Element id = DocumentHelper.createElement((String)"id");
                id.addText((String)pair.getKey());
                ele.add(id);
                Element name = DocumentHelper.createElement((String)"displayName");
                String value = (String)pair.getValue();
                if (value != null) {
                    name.addText(value);
                }
                ele.add(name);
                paramElem.add(ele);
            }
        }
    }

    private void addProductLocalesElement(Locale locale, Element paramElem) throws CCLConfigurationException {
        Map plmap = this.m_oConfig.getProductLocaleList(LocaleUtils.toNormalizedString(locale));
        if (plmap != null) {
            Map sortedMap = this.sort(locale, plmap);
            for (Map.Entry pair : sortedMap.values()) {
                Element ele = DocumentHelper.createElement((String)"locale");
                ele.addAttribute("type", "productLocale");
                Element id = DocumentHelper.createElement((String)"id");
                id.addText((String)pair.getKey());
                ele.add(id);
                Element name = DocumentHelper.createElement((String)"displayName");
                String value = (String)pair.getValue();
                if (value != null) {
                    name.addText(value);
                }
                ele.add(name);
                paramElem.add(ele);
            }
        }
    }

    private void addTimeZonesElement(Locale locale, Element paramElem) throws CCLConfigurationException {
        Map tzmap = this.m_oConfig.getTimeZones(LocaleUtils.toNormalizedString(locale));
        if (tzmap != null) {
            for (Map.Entry pair : tzmap.entrySet()) {
                Element ele = DocumentHelper.createElement((String)"timezone");
                Element id = DocumentHelper.createElement((String)"id");
                id.addText((String)pair.getKey());
                ele.add(id);
                Element name = DocumentHelper.createElement((String)"displayName");
                String value = (String)pair.getValue();
                if (value != null) {
                    name.addText(value);
                }
                ele.add(name);
                paramElem.add(ele);
            }
        }
    }
}

