/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.IXTSCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.ext.base64;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.security.IXTSCacheSecurity;
import com.cognos.xts.security.XTSSecurityException;
import com.cognos.xts.security.XTSSecurityFactory;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class XTSEncryptFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final String PARAM_NAME_PROVIDER = "provider";
    private static final String PARAM_NAME_ENCODING = "encoding";
    private static final String PARAM_NAME_SOURCE = "source";
    private static final String PARAM_NAME_ENCODE = "encode";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        String cleartext;
        if (!this.m_bInitialized) {
            return null;
        }
        String securityProvider = UXTSInstructionUtils.getParameter(PARAM_NAME_PROVIDER, instParams);
        if (securityProvider == null || securityProvider.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_PROVIDER, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String encoding = UXTSInstructionUtils.getParameter(PARAM_NAME_ENCODING, instParams);
        if (encoding == null || encoding.length() == 0) {
            encoding = DEFAULT_ENCODING;
        }
        if ((cleartext = UXTSInstructionUtils.getParameter(PARAM_NAME_SOURCE, instParams)) == null) {
            Object[] args = new String[]{PARAM_NAME_SOURCE, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String encryptedtext = null;
        IXTSCacheObject secObj = null;
        try {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("name", securityProvider);
            secObj = (IXTSCacheSecurity)((Object)XTSSecurityFactory.getInstance().getObject(env, attr));
            if (secObj == null) {
                throw new XTSInstructionException("encrypt.emptySecurityObject");
            }
            byte[] source = cleartext.getBytes(encoding);
            byte[] target = secObj.encrypt(env, source, null);
            encryptedtext = base64.encode(0, target);
            String encode = UXTSInstructionUtils.getParameter(PARAM_NAME_ENCODE, instParams);
            if (encode != null) {
                if (encode.equals("url")) {
                    encryptedtext = XTSExt.urlencode(encryptedtext);
                } else if (encode.equals("xml")) {
                    encryptedtext = XTSExt.xmlencode(encryptedtext);
                } else if (encode.equals("html")) {
                    encryptedtext = XTSExt.htmlencode(encryptedtext);
                } else if (encode.equals("javascript")) {
                    encryptedtext = XTSExt.javascriptencode(encryptedtext);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSSecurityException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSCacheException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        finally {
            if (secObj != null) {
                secObj.release();
            }
        }
        return new XTSFunctionResult(encryptedtext);
    }
}

