/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.util.LocaleUtils;
import com.cognos.xts.util.SequenceReader;
import com.cognos.xts.util.xmlutil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XTSGetLocalizedNameFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final char OPEN_BRACKET_START = '<';
    protected static final char OPEN_BRACKET_END = '>';
    protected static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    protected static final char CLOSE_BRACKET_END = '>';
    protected static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    protected static final char EQUALS = '=';
    protected static final char QUOTE = '\"';
    protected static final char SPACE = ' ';
    protected static final char COLON = ':';
    protected static final char ENTITYREF_START = '&';
    protected static final char ENTITYREF_END = ';';
    private static final String PARAM_NAME_XMLENCODE = "xmlencode";
    private static final String PARAM_NAME_LOCALE = "locale";
    private static final String PARAM_NAME_NAMELIST = "namelist";
    private static final String PARAM_NAME_DEFAULT = "default";
    private static final String PARAM_NAME_NORMALIZE = "normalize";
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    private String match(String localeList, ArrayList nameList) throws XTSConfigurationException {
        nameEntry ne;
        int i;
        Locale lo;
        if (nameList == null || nameList.size() == 0) {
            return null;
        }
        if (localeList == null || localeList.length() == 0) {
            return null;
        }
        ArrayList<Locale> normalizedLocaleList = new ArrayList<Locale>();
        StringTokenizer st = new StringTokenizer(localeList, ",");
        while (st.hasMoreTokens()) {
            String locale = st.nextToken().trim();
            int idx = locale.indexOf(";");
            if (idx != -1) {
                locale = locale.substring(0, idx);
            }
            lo = LocaleUtils.toLocale(LocaleUtils.toNormalizedString(locale));
            if (!XTSConfigManager.getInstance().validateContentLocale(lo)) continue;
            for (int i2 = 0; i2 < nameList.size(); ++i2) {
                nameEntry ne2 = (nameEntry)nameList.get(i2);
                if (!lo.equals(ne2.getLocale())) continue;
                return ne2.getBuffer().toString();
            }
            normalizedLocaleList.add(lo);
        }
        ArrayList<Locale> mappedLocaleList = new ArrayList<Locale>();
        for (i = 0; i < normalizedLocaleList.size(); ++i) {
            lo = (Locale)normalizedLocaleList.get(i);
            Locale maplocale = XTSConfigManager.getInstance().mapContentLocale(lo);
            if (maplocale == null) continue;
            for (int j = 0; j < nameList.size(); ++j) {
                ne = (nameEntry)nameList.get(j);
                if (!maplocale.equals(ne.getLocale())) continue;
                return ne.getBuffer().toString();
            }
            mappedLocaleList.add(maplocale);
        }
        for (i = 0; i < mappedLocaleList.size(); ++i) {
            lo = (Locale)mappedLocaleList.get(i);
            Locale maplocale = XTSConfigManager.getInstance().mapContentLocale(lo);
            if (maplocale == null) continue;
            for (int j = 0; j < nameList.size(); ++j) {
                ne = (nameEntry)nameList.get(j);
                Locale nelocale = XTSConfigManager.getInstance().mapContentLocale(ne.getLocale());
                if (!maplocale.equals(nelocale)) continue;
                return ne.getBuffer().toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        String localeList;
        if (!this.m_bInitialized) {
            return null;
        }
        boolean bXMLEncode = false;
        String xmlEncode = UXTSInstructionUtils.getParameter(PARAM_NAME_XMLENCODE, instParams);
        if (xmlEncode != null && xmlEncode.equals("true")) {
            bXMLEncode = true;
        }
        if ((localeList = UXTSInstructionUtils.getParameter(PARAM_NAME_LOCALE, instParams)) == null || localeList.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_LOCALE, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String namelist = UXTSInstructionUtils.getParameter(PARAM_NAME_NAMELIST, instParams);
        if (namelist == null || namelist.length() == 0) {
            Object[] args = new String[]{this.m_sIdentifier, PARAM_NAME_NAMELIST};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String defaultname = UXTSInstructionUtils.getParameter(PARAM_NAME_DEFAULT, instParams);
        if (defaultname == null || defaultname.length() == 0) {
            Object[] args = new String[]{this.m_sIdentifier, PARAM_NAME_DEFAULT};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String normalize = UXTSInstructionUtils.getParameter(PARAM_NAME_NORMALIZE, instParams);
        if (normalize == null || normalize.length() == 0) {
            Object[] args = new String[]{this.m_sIdentifier, PARAM_NAME_NORMALIZE};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String result = defaultname;
        try {
            SequenceReader sr = new SequenceReader(new StringReader("<xtsdummy>"), new SequenceReader(new StringReader(namelist), new StringReader("</xtsdummy>")));
            fnHandler handler = new fnHandler();
            AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
            try {
                XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                reader.setContentHandler(handler);
                reader.setProperty(LEXICALHANDLER_PROPERTY, handler);
                reader.parse(new InputSource(sr));
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
            String matchResult = this.match(localeList, handler.getNameList());
            if (matchResult != null) {
                result = matchResult;
            }
            if (bXMLEncode) {
                result = XTSExt.xmlencode(result);
            }
        }
        catch (SAXException e) {
            throw new XTSInstructionException("function.exception", e);
        }
        catch (IOException e) {
            throw new XTSInstructionException("function.exception", e);
        }
        catch (XTSConfigurationException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        return new XTSFunctionResult(result);
    }

    class fnHandler
    extends DefaultHandler
    implements LexicalHandler {
        String m_currentEntity = null;
        int m_curDepth = 0;
        ArrayList m_globalNS = new ArrayList();
        Locale m_curLocale = null;
        StringBuffer m_curBuffer = null;
        ArrayList m_curNS = null;
        ArrayList m_nameList = new ArrayList();

        fnHandler() {
        }

        ArrayList getNameList() {
            return this.m_nameList;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            if (this.m_curNS == null) {
                this.m_globalNS.add(new nsEntry(prefix, uri));
            } else {
                this.m_curNS.add(new nsEntry(prefix, uri));
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (prefix == null) {
                prefix = "";
            }
            if (this.m_curNS == null) {
                for (int i = this.m_globalNS.size() - 1; i >= 0; --i) {
                    nsEntry ns = (nsEntry)this.m_globalNS.get(i);
                    if (!prefix.equals(ns.getPrefix())) continue;
                    this.m_globalNS.remove(i);
                    break;
                }
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.m_currentEntity = null;
            if (this.m_curBuffer != null) {
                this.wirteStartElement(namespaceURI, localName, qName, atts);
                this.m_curNS.clear();
            } else if (this.m_curDepth == 1 && namespaceURI.length() == 0 && localName.equals("name")) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (atts.getURI(i).length() != 0 || !atts.getLocalName(i).equals(XTSGetLocalizedNameFunction.PARAM_NAME_LOCALE)) continue;
                    this.m_curLocale = LocaleUtils.toLocale(LocaleUtils.toNormalizedString(atts.getValue(i)));
                    break;
                }
                this.m_curBuffer = new StringBuffer();
                this.m_curNS = new ArrayList(this.m_globalNS);
            }
            ++this.m_curDepth;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            --this.m_curDepth;
            if (this.m_curDepth == 1 && namespaceURI.length() == 0 && localName.equals("name")) {
                this.m_nameList.add(new nameEntry(this.m_curLocale, this.m_curBuffer));
                this.m_curLocale = null;
                this.m_curBuffer = null;
                this.m_curNS = null;
            } else if (this.m_curBuffer != null) {
                this.writeEndElement(namespaceURI, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.m_curBuffer != null) {
                if (this.m_currentEntity != null) {
                    this.m_currentEntity = xmlutil.outEntityReference(this.m_currentEntity, ch, start, length);
                    this.m_curBuffer.append(this.m_currentEntity.toCharArray(), 0, this.m_currentEntity.length());
                } else {
                    this.m_curBuffer.append(ch, start, length);
                }
            }
            this.m_currentEntity = null;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.m_curBuffer != null) {
                this.m_curBuffer.append(ch, start, length);
            }
        }

        @Override
        public void startEntity(String name) throws SAXException {
            this.m_currentEntity = '&' + name + ';';
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int end) throws SAXException {
        }

        public void wirteStartElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.m_curBuffer.append('<');
            this.m_curBuffer.append(qName);
            for (int j = 0; j < atts.getLength(); ++j) {
                this.m_curBuffer.append(' ');
                this.m_curBuffer.append(atts.getQName(j));
                this.m_curBuffer.append('=');
                this.m_curBuffer.append('\"');
                this.m_curBuffer.append(XTSExt.xmlencode(atts.getValue(j)));
                this.m_curBuffer.append('\"');
            }
            for (int k = 0; k < this.m_curNS.size(); ++k) {
                nsEntry ns = (nsEntry)this.m_curNS.get(k);
                this.m_curBuffer.append(' ');
                this.m_curBuffer.append(XMLNS);
                if (ns.getPrefix().length() > 0) {
                    this.m_curBuffer.append(':');
                    this.m_curBuffer.append(ns.getPrefix());
                }
                this.m_curBuffer.append('=');
                this.m_curBuffer.append('\"');
                this.m_curBuffer.append(ns.getURL());
                this.m_curBuffer.append('\"');
            }
            this.m_curBuffer.append('>');
        }

        public void writeEndElement(String namespaceURI, String localName, String qName) {
            this.m_curBuffer.append(CLOSE_BRACKET_START);
            this.m_curBuffer.append(qName);
            this.m_curBuffer.append('>');
        }
    }

    class nsEntry {
        String m_prefix;
        String m_url;

        nsEntry(String prefix, String url) {
            this.m_prefix = prefix;
            this.m_url = url;
        }

        String getPrefix() {
            return this.m_prefix;
        }

        String getURL() {
            return this.m_url;
        }
    }

    class nameEntry {
        Locale m_locale;
        StringBuffer m_buffer;

        nameEntry(Locale locale, StringBuffer buffer) {
            this.m_locale = locale;
            this.m_buffer = buffer;
        }

        void setLocale(Locale locale) {
            this.m_locale = locale;
        }

        Locale getLocale() {
            return this.m_locale;
        }

        StringBuffer getBuffer() {
            return this.m_buffer;
        }
    }
}

