/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.IXTSCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.security.IXTSCacheSecurity;
import com.cognos.xts.security.XTSSecurityException;
import com.cognos.xts.security.XTSSecurityFactory;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class XTSGetRequestExternalFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final String PARAM_NAME_PROVIDER = "provider";
    private static final String PARAM_NAME_ENCODING = "encoding";
    private static final String PARAM_NAME_SECURESTATE = "secureState";
    private static final String PARAM_NAME_PASSPORT = "passport";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_SECURITY_PROVIDER = "cognos.cam";
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        String passport;
        String encoding;
        if (!this.m_bInitialized) {
            return null;
        }
        String securityProvider = UXTSInstructionUtils.getParameter(PARAM_NAME_PROVIDER, instParams);
        if (securityProvider == null || securityProvider.length() == 0) {
            securityProvider = DEFAULT_SECURITY_PROVIDER;
        }
        if ((encoding = UXTSInstructionUtils.getParameter(PARAM_NAME_ENCODING, instParams)) == null || encoding.length() == 0) {
            encoding = DEFAULT_ENCODING;
        }
        if ((passport = UXTSInstructionUtils.getParameter(PARAM_NAME_PASSPORT, instParams)) == null || passport.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_PASSPORT, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String secureState = UXTSInstructionUtils.getParameter(PARAM_NAME_SECURESTATE, instParams);
        if (secureState == null || secureState.length() == 0) {
            secureState = new String("");
        }
        IXTSCacheObject secObj = null;
        boolean signSpecification = false;
        try {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("name", securityProvider);
            secObj = (IXTSCacheSecurity)((Object)XTSSecurityFactory.getInstance().getObject(env, attr));
            if (secObj == null) {
                throw new XTSInstructionException("getrequestexternal.emptySecurityObject");
            }
            signSpecification = secObj.getRequestExternal(env, passport.getBytes(encoding), secureState.getBytes(encoding), null);
        }
        catch (UnsupportedEncodingException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSSecurityException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSCacheException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        finally {
            if (secObj != null) {
                secObj.release();
            }
        }
        Boolean result = new Boolean(signSpecification);
        return new XTSFunctionResult(result.toString());
    }
}

