/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.util.LocaleUtils;
import java.util.Map;

public class XTSMapContentLocaleFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final String PARAM_NAME_LOCALE = "locale";
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        if (!this.m_bInitialized) {
            return null;
        }
        String locale = UXTSInstructionUtils.getParameter(PARAM_NAME_LOCALE, instParams);
        if (locale == null || locale.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_LOCALE, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        String result = null;
        try {
            result = LocaleUtils.toNormalizedString(XTSConfigManager.getInstance().mapContentLocale(LocaleUtils.toLocale(locale)));
        }
        catch (XTSConfigurationException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        if (result == null) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args);
        }
        return new XTSFunctionResult(result);
    }
}

