/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.IXTSCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.security.IXTSCacheSecurity;
import com.cognos.xts.security.XTSSecurityException;
import com.cognos.xts.security.XTSSecurityFactory;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class XTSSignReportSpecFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final String PARAM_NAME_PROVIDER = "provider";
    private static final String PARAM_NAME_ENCODING = "encoding";
    private static final String PARAM_NAME_SOURCE = "source";
    private static final String PARAM_NAME_ENCODE = "encode";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_SECURITY_PROVIDER = "cognos.cam";
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        String source;
        String encoding;
        if (!this.m_bInitialized) {
            return null;
        }
        String securityProvider = UXTSInstructionUtils.getParameter(PARAM_NAME_PROVIDER, instParams);
        if (securityProvider == null || securityProvider.length() == 0) {
            securityProvider = DEFAULT_SECURITY_PROVIDER;
        }
        if ((encoding = UXTSInstructionUtils.getParameter(PARAM_NAME_ENCODING, instParams)) == null || encoding.length() == 0) {
            encoding = DEFAULT_ENCODING;
        }
        if ((source = UXTSInstructionUtils.getParameter(PARAM_NAME_SOURCE, instParams)) == null || source.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_SOURCE, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        IXTSCacheObject secObj = null;
        String signedSpec = null;
        try {
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("name", securityProvider);
            secObj = (IXTSCacheSecurity)((Object)XTSSecurityFactory.getInstance().getObject(env, attr));
            if (secObj == null) {
                throw new XTSInstructionException("signspec.emptySecurityObject");
            }
            byte[] result = secObj.signReportSpec(env, source.getBytes(encoding), null);
            signedSpec = new String(result, encoding);
            String encode = UXTSInstructionUtils.getParameter(PARAM_NAME_ENCODE, instParams);
            if (encode != null) {
                if (encode.equals("url")) {
                    signedSpec = XTSExt.urlencode(signedSpec);
                } else if (encode.equals("xml")) {
                    signedSpec = XTSExt.xmlencode(signedSpec);
                } else if (encode.equals("html")) {
                    signedSpec = XTSExt.htmlencode(signedSpec);
                } else if (encode.equals("javascript")) {
                    signedSpec = XTSExt.javascriptencode(signedSpec);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSSecurityException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        catch (XTSCacheException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("function.exception", args, e);
        }
        finally {
            if (secObj != null) {
                secObj.release();
            }
        }
        return new XTSFunctionResult(signedSpec);
    }
}

