/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSVersions;
import com.cognos.xts.logging.IXTSLogger;

public class IPFAuditAccessLogger
implements IXTSLogger {
    private static final String m_component = "xts";
    private LogAuditAccessIndication m_indication = null;
    private LogTypedLogger m_logger = null;
    private static final String m_requestHeader = "<request>";
    private static final String m_requestFooter = "</request>";
    private static final String m_responseHeader = "<response>";
    private static final String m_responseFooter = "</response>";

    public IPFAuditAccessLogger(LogTypedLogger logger, int level) {
        int nBldNum = 0;
        try {
            nBldNum = Integer.parseInt(XTSVersions.getXTSMajorBldVersion());
        }
        catch (Exception e) {
            nBldNum = 0;
        }
        this.m_logger = logger;
        this.m_indication = new LogAuditAccessIndication(m_component, nBldNum);
        this.m_indication.setLevel(level);
    }

    @Override
    public void log(XTSEnvironment env, int operation, String status, String message2, String s3) {
        if (env != null) {
            this.m_indication.setRequestID(env.getRequestContext());
            this.m_indication.setSessionID(env.getSessionContext());
            this.m_indication.setStepID(env.getStepContext());
            this.m_indication.setSubRequestID(env.getSubRequestContext());
        }
        this.m_indication.setOperation(this.getIPFOperation(operation));
        this.m_indication.setObjectType("PresentationService");
        this.m_indication.setObjectPath("");
        this.m_indication.setStatus(this.getIPFStatus(status));
        StringBuffer msg = new StringBuffer();
        if (operation == 2) {
            msg.append(m_requestHeader);
            msg.append(message2);
            msg.append(m_requestFooter);
        } else if (operation == 3) {
            msg.append(m_responseHeader);
            msg.append(message2);
            msg.append(m_responseFooter);
        } else {
            msg.append(message2);
        }
        this.m_indication.setErrorMessage(msg.toString());
        this.m_logger.log((Object)this.m_indication);
    }

    @Override
    public void starttimer() {
    }

    @Override
    public void stoptimer() {
    }

    private String getIPFOperation(int operation) {
        switch (operation) {
            case 0: {
                return "StartService";
            }
            case 1: {
                return "StopService";
            }
            case 2: {
                return "Request";
            }
            case 3: {
                return "Response";
            }
            case 4: {
                return "Upgrade";
            }
            case 5: {
                return "Info";
            }
        }
        return "Request";
    }

    private String getIPFStatus(String status) {
        String xtsStatus = status.toLowerCase();
        if (xtsStatus.compareTo("success") == 0) {
            return "Success";
        }
        if (xtsStatus.compareTo("failure") == 0) {
            return "Failure";
        }
        return status;
    }
}

