/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xts.baltic.logging.IPFAuditAccessLogger;
import com.cognos.xts.baltic.logging.IPFAuditLogger;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.IXTSLoggerManager;
import com.cognos.xts.logging.XTSLoggingException;

public class IPFAuditLoggerManager
implements IXTSLoggerManager {
    private LogTypedLogger[][] m_auditLoggers = new LogTypedLogger[2][2];

    public IPFAuditLoggerManager() {
        this.m_auditLoggers[0][0] = LogTypedLogger.getInstance((String)"Audit.xts", LogAuditAccessIndication.class);
        this.m_auditLoggers[0][1] = LogTypedLogger.getInstance((String)"Audit.xts", LogAuditIndication.class);
        this.m_auditLoggers[1][0] = LogTypedLogger.getInstance((String)"Audit.Other.xts.request", LogAuditAccessIndication.class);
        this.m_auditLoggers[1][1] = LogTypedLogger.getInstance((String)"Audit.Other.xts.request", LogAuditIndication.class);
    }

    @Override
    public boolean isEnabled(int level, int area) throws XTSLoggingException {
        if (level <= 2) {
            return this.m_auditLoggers[area][0].isEnabled(this.getIPFLevel(level, area));
        }
        return this.m_auditLoggers[area][1].isEnabled(this.getIPFLevel(level, area));
    }

    @Override
    public IXTSLogger getLogger(int level, int area) throws XTSLoggingException {
        if (level <= 2) {
            return new IPFAuditAccessLogger(this.m_auditLoggers[area][0], this.getIPFLevel(level, area));
        }
        return new IPFAuditLogger(this.m_auditLoggers[area][1], this.getIPFLevel(level, area));
    }

    private int getIPFLevel(int level, int area) {
        switch (level) {
            case 0: {
                return 50000;
            }
            case 1: {
                return 40000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 20000;
            }
            case 4: {
                return 10000;
            }
        }
        return 10000;
    }
}

