/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.logging;

import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogResourceCounterSet;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSVersions;
import com.cognos.xts.logging.IXTSLogger;

public class IPFPerfLogger
implements IXTSLogger {
    private static final String m_component = "xts";
    private LogResourceCounterSet m_counter = null;
    private LogPerfIndication m_indication = null;
    private LogTypedLogger m_logger = null;

    public IPFPerfLogger(LogTypedLogger logger, int level) {
        int nBldNum = 0;
        try {
            nBldNum = Integer.parseInt(XTSVersions.getXTSMajorBldVersion());
        }
        catch (Exception e) {
            nBldNum = 0;
        }
        this.m_logger = logger;
        this.m_counter = new LogResourceCounterSet("Execution", null);
        this.m_indication = new LogPerfIndication(m_component, nBldNum, this.m_counter);
        this.m_indication.setLevel(level);
    }

    @Override
    public void starttimer() {
        this.m_counter.enableResourceCounter();
    }

    @Override
    public void stoptimer() {
        this.m_counter.disableResourceCounter();
    }

    @Override
    public void log(XTSEnvironment env, int operation, String classname, String methodname, String description) {
        if (env != null) {
            this.m_indication.setRequestID(env.getRequestContext());
            this.m_indication.setSessionID(env.getSessionContext());
            this.m_indication.setStepID(env.getStepContext());
            this.m_indication.setSubRequestID(env.getSubRequestContext());
        }
        this.m_indication.setClassId(classname);
        this.m_indication.setMethodId(methodname);
        this.m_indication.setLogData(description);
        this.m_indication.setStatus(this.getIPFOperation(operation));
        this.m_indication.setTime(System.currentTimeMillis());
        this.m_logger.log((Object)this.m_indication);
    }

    private String getIPFOperation(int operation) {
        switch (operation) {
            case 0: {
                return "START";
            }
            case 1: {
                return "FINISH";
            }
            case 2: {
                return "ENTER";
            }
            case 3: {
                return "EXIT";
            }
            case 4: {
                return "CALL";
            }
            case 5: {
                return "RETURN";
            }
            case 6: {
                return "BEGIN";
            }
            case 7: {
                return "LOG";
            }
        }
        return "LOG";
    }
}

