/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.logging;

import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xts.baltic.logging.IPFPerfLogger;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.IXTSLoggerManager;
import com.cognos.xts.logging.XTSLoggingException;

public class IPFPerfLoggerManager
implements IXTSLoggerManager {
    private LogTypedLogger[] m_perfLoggers = new LogTypedLogger[1];

    public IPFPerfLoggerManager() {
        this.m_perfLoggers[0] = LogTypedLogger.getInstance((String)"Perf.xts", LogPerfIndication.class);
    }

    @Override
    public boolean isEnabled(int level, int area) throws XTSLoggingException {
        return this.m_perfLoggers[area].isEnabled(this.getIPFLevel(level));
    }

    @Override
    public IXTSLogger getLogger(int level, int area) throws XTSLoggingException {
        return new IPFPerfLogger(this.m_perfLoggers[area], this.getIPFLevel(level));
    }

    private int getIPFLevel(int level) {
        switch (level) {
            case 0: {
                return 50000;
            }
            case 1: {
                return 40000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 20000;
            }
            case 4: {
                return 10000;
            }
        }
        return 10000;
    }
}

