/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.logging;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSVersions;
import com.cognos.xts.logging.IXTSLogger;

public class IPFTraceLogger
implements IXTSLogger {
    private static final String m_component = "xts";
    private LogTraceIndication m_indication = null;
    private LogTypedLogger m_logger = null;
    private static final String m_traceHeader = "<trace>";
    private static final String m_traceFooter = "</trace>";

    public IPFTraceLogger(LogTypedLogger logger, int level) {
        int nBldNum = 0;
        try {
            nBldNum = Integer.parseInt(XTSVersions.getXTSMajorBldVersion());
        }
        catch (Exception e) {
            nBldNum = 0;
        }
        this.m_logger = logger;
        this.m_indication = new LogTraceIndication(m_component, nBldNum);
        this.m_indication.setLevel(level);
    }

    @Override
    public void starttimer() {
    }

    @Override
    public void stoptimer() {
    }

    @Override
    public void log(XTSEnvironment env, int operation, String tracemsg, String s2, String s3) {
        if (env != null) {
            this.m_indication.setRequestID(env.getRequestContext());
            this.m_indication.setSessionID(env.getSessionContext());
            this.m_indication.setStepID(env.getStepContext());
            this.m_indication.setSubRequestID(env.getSubRequestContext());
        }
        this.m_indication.setObject(m_component);
        this.m_indication.setAction(this.getIPFOperation(operation));
        StringBuffer msg = new StringBuffer();
        msg.append(m_traceHeader);
        msg.append(tracemsg);
        msg.append(m_traceFooter);
        this.m_indication.setMessage(msg.toString());
        this.m_logger.log((Object)this.m_indication);
    }

    private byte getIPFOperation(int operation) {
        switch (operation) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 11;
            }
        }
        return 11;
    }
}

