/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSVersions;
import java.util.HashMap;
import java.util.Map;

public class IPFUserDefinedLogger {
    private static final String PARAM_NAME_INDICATION = "indication";
    private static final String PARAM_NAME_LEVEL = "level";
    private static final String PARAM_NAME_OPERATION = "operation";
    private static final String PARAM_NAME_LOGDATA = "logData";
    private static final String PARAM_NAME_OBJECTTYPE = "objectType";
    private static final String PARAM_NAME_OBJECTPATH = "objectPath";
    private static final String PARAM_NAME_STATUS = "status";
    private static final String PARAM_NAME_ERRORMESSAGE = "errorMessage";
    private static final String PARAM_NAME_MESSAGE = "message";
    private static final String PARAM_NAME_ACTION = "action";
    private static final String PARAM_NAME_OBJECT = "object";
    private static final int TYPE_AUDIT = 0;
    private static final int TYPE_TRACE = 1;
    private static final String COMPONENT = "xts";
    private static IPFUserDefinedLogger m_instance = new IPFUserDefinedLogger();
    private HashMap m_Loggers = new HashMap();
    private int m_bldNum = 0;

    public static IPFUserDefinedLogger getInstance() {
        return m_instance;
    }

    public void log(XTSEnvironment env, Map paramMap) throws XTSException {
        String indication = this.getParameter(PARAM_NAME_INDICATION, paramMap);
        if (indication == null || indication.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_INDICATION, this.getClass().getName()};
            throw new XTSException("function.emptyparameter", args);
        }
        String sLevel = this.getParameter(PARAM_NAME_LEVEL, paramMap);
        if (sLevel == null || sLevel.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_LEVEL, this.getClass().getName()};
            throw new XTSException("function.emptyparameter", args);
        }
        int level = 1;
        try {
            level = Integer.parseInt(sLevel);
        }
        catch (NumberFormatException e) {
            level = 1;
        }
        int logtype = this.getLogType(indication);
        LogTypedLogger[] loggers = this.getLoggers(logtype, indication);
        if (this.isEnabled(loggers, level)) {
            if (level <= 3) {
                if (logtype == 0) {
                    this.logAuditAccessIndication(env, loggers[0], this.getIPFLevel(level), paramMap);
                } else if (logtype == 1) {
                    this.logTraceIndication(env, loggers[0], this.getIPFLevel(level), paramMap);
                }
            } else if (logtype == 0) {
                this.logAuditIndication(env, loggers[0], this.getIPFLevel(level), paramMap);
            } else if (logtype == 1) {
                this.logTraceIndication(env, loggers[0], this.getIPFLevel(level), paramMap);
            }
        }
    }

    private IPFUserDefinedLogger() {
        try {
            this.m_bldNum = Integer.parseInt(XTSVersions.getXTSMajorBldVersion());
        }
        catch (NumberFormatException e) {
            this.m_bldNum = 0;
        }
    }

    private int getLogType(String indication) throws XTSException {
        if (indication.equals("Audit") || indication.startsWith("Audit.")) {
            return 0;
        }
        if (indication.equals("Trace") || indication.startsWith("Trace.")) {
            return 1;
        }
        Object[] args = new String[]{indication};
        throw new XTSException("logger.invalidindication", args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogTypedLogger[] getLoggers(int logtype, String indication) {
        HashMap hashMap = this.m_Loggers;
        synchronized (hashMap) {
            LogTypedLogger[] loggers = (LogTypedLogger[])this.m_Loggers.get(indication);
            if (loggers == null) {
                loggers = this.createLoggers(logtype, indication);
                this.m_Loggers.put(indication, loggers);
            }
            return loggers;
        }
    }

    private LogTypedLogger[] createLoggers(int logtype, String indication) {
        if (logtype == 0) {
            LogTypedLogger[] loggers = new LogTypedLogger[]{LogTypedLogger.getInstance((String)indication, LogAuditAccessIndication.class), LogTypedLogger.getInstance((String)indication, LogAuditIndication.class)};
            return loggers;
        }
        if (logtype == 1) {
            LogTypedLogger[] loggers = new LogTypedLogger[]{LogTypedLogger.getInstance((String)indication, LogTraceIndication.class), LogTypedLogger.getInstance((String)indication, LogTraceIndication.class)};
            return loggers;
        }
        return null;
    }

    private boolean isEnabled(LogTypedLogger[] loggers, int level) {
        if (level <= 3) {
            return loggers[0].isEnabled(this.getIPFLevel(level));
        }
        return loggers[1].isEnabled(this.getIPFLevel(level));
    }

    private int getIPFLevel(int level) {
        switch (level) {
            case 1: {
                return 50000;
            }
            case 2: {
                return 40000;
            }
            case 3: {
                return 30000;
            }
            case 4: {
                return 20000;
            }
            case 5: {
                return 10000;
            }
        }
        return 10000;
    }

    private void logAuditIndication(XTSEnvironment env, LogTypedLogger logger, int ipflevel, Map paramMap) {
        String operation;
        LogAuditIndication indication = new LogAuditIndication(COMPONENT, this.m_bldNum);
        indication.setLevel(ipflevel);
        if (env != null) {
            indication.setRequestID(env.getRequestContext());
            indication.setSessionID(env.getSessionContext());
            indication.setStepID(env.getStepContext());
            indication.setSubRequestID(env.getSubRequestContext());
        }
        if ((operation = this.getParameter(PARAM_NAME_OPERATION, paramMap)) == null) {
            operation = "";
        }
        indication.setOperation(operation);
        String logData = this.getParameter(PARAM_NAME_LOGDATA, paramMap);
        if (logData == null) {
            logData = "";
        }
        indication.setLogData(logData);
        logger.log((Object)indication);
    }

    private void logAuditAccessIndication(XTSEnvironment env, LogTypedLogger logger, int ipflevel, Map paramMap) {
        String operation;
        LogAuditAccessIndication indication = new LogAuditAccessIndication(COMPONENT, this.m_bldNum);
        indication.setLevel(ipflevel);
        if (env != null) {
            indication.setRequestID(env.getRequestContext());
            indication.setSessionID(env.getSessionContext());
            indication.setStepID(env.getStepContext());
            indication.setSubRequestID(env.getSubRequestContext());
        }
        if ((operation = this.getParameter(PARAM_NAME_OPERATION, paramMap)) == null) {
            operation = "";
        }
        indication.setOperation(operation);
        String logData = this.getParameter(PARAM_NAME_LOGDATA, paramMap);
        if (logData == null) {
            logData = "";
        }
        indication.setLogData(logData);
        String objectType = this.getParameter(PARAM_NAME_OBJECTTYPE, paramMap);
        if (objectType == null) {
            objectType = "";
        }
        indication.setObjectType(objectType);
        String objectPath = this.getParameter(PARAM_NAME_OBJECTPATH, paramMap);
        if (objectPath == null) {
            objectPath = "";
        }
        indication.setObjectPath(objectPath);
        String status = this.getParameter(PARAM_NAME_STATUS, paramMap);
        if (status == null) {
            status = "";
        }
        indication.setStatus(status);
        String errorMessage = this.getParameter(PARAM_NAME_ERRORMESSAGE, paramMap);
        if (errorMessage == null) {
            errorMessage = "";
        }
        indication.setErrorMessage(errorMessage);
        logger.log((Object)indication);
    }

    private void logTraceIndication(XTSEnvironment env, LogTypedLogger logger, int ipflevel, Map paramMap) {
        String message2;
        LogTraceIndication indication = new LogTraceIndication(COMPONENT, this.m_bldNum);
        indication.setLevel(ipflevel);
        if (env != null) {
            indication.setRequestID(env.getRequestContext());
            indication.setSessionID(env.getSessionContext());
            indication.setStepID(env.getStepContext());
            indication.setSubRequestID(env.getSubRequestContext());
        }
        if ((message2 = this.getParameter(PARAM_NAME_MESSAGE, paramMap)) == null) {
            message2 = "";
        }
        indication.setMessage(message2);
        String object = this.getParameter(PARAM_NAME_OBJECT, paramMap);
        if (object == null) {
            object = "";
        }
        indication.setObject(object);
        byte action = 0;
        String sAction = this.getParameter(PARAM_NAME_ACTION, paramMap);
        if (sAction != null && sAction.length() > 0) {
            try {
                action = Byte.parseByte(sAction);
            }
            catch (NumberFormatException e) {
                action = 0;
            }
        }
        indication.setAction(action);
        logger.log((Object)indication);
    }

    private String getParameter(String name, Map paramMap) {
        String[] values = (String[])paramMap.get(name);
        return values == null ? null : values[0];
    }
}

