/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.cache.AXTSFastCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.XMLFilter;

public class CMTemplate
extends AXTSFastCacheObject {
    private static final String IDENTIFIER = "CMTemplate";
    private static final String PROPERTY_TRANSFORMER = "request.class.CM.transform";
    public static final String ATT_NM_XSLT = "xslt";
    public static final String ATT_NM_URLRESOLVER = "urlResolver";
    private String m_sTransformerFactoryClassName = null;
    private String m_sXSLT = null;
    private Templates m_oTemplate = null;
    private XMLFilter m_oXMLFilter = null;
    private URIResolver m_oURIResolver = null;
    private String m_sTemplateRoot = null;

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected void initialize_Impl(XTSEnvironment env, Map atts) throws XTSCacheException {
        this.m_sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
        this.m_oURIResolver = (URIResolver)atts.get(ATT_NM_URLRESOLVER);
        this.m_sTransformerFactoryClassName = PropertiesManager.getInstance().getProperty(PROPERTY_TRANSFORMER);
        this.m_sXSLT = (String)atts.get(ATT_NM_XSLT);
        try {
            TransformerFactory factory = (TransformerFactory)Class.forName(this.m_sTransformerFactoryClassName).newInstance();
            if (this.m_oURIResolver != null) {
                factory.setURIResolver(this.m_oURIResolver);
            }
            String xslt = PathUtils.buildPath(this.m_sXSLT);
            InputStream is = null;
            try {
                is = XTSResourceManager.getInstance().getResource(xslt);
            }
            catch (XTSException e) {
                Object[] args = new String[]{IDENTIFIER, this.m_sTemplateRoot, this.m_sXSLT};
                throw new XTSCacheException("instruction.buildfullpathfailed", args, e);
            }
            if (is == null) {
                Object[] args = new String[]{IDENTIFIER, this.m_sTemplateRoot, this.m_sXSLT};
                throw new XTSCacheException("instruction.buildfullpathfailed", args);
            }
            StreamSource xsltsrc = new StreamSource(is);
            xsltsrc.setSystemId(xslt);
            this.m_oTemplate = factory.newTemplates(xsltsrc);
            SAXTransformerFactory saxTransformFactory = (SAXTransformerFactory)factory;
            this.m_oXMLFilter = saxTransformFactory.newXMLFilter(this.m_oTemplate);
        }
        catch (IOException e) {
            Object[] args = new String[]{IDENTIFIER, this.m_sTemplateRoot, this.m_sXSLT};
            throw new XTSCacheException("instruction.buildfullpathfailed", args, e);
        }
        catch (TransformerException e) {
            Object[] args = new String[]{IDENTIFIER, this.m_sXSLT};
            throw new XTSCacheException("transformer.compileerror", args, e);
        }
        catch (IllegalAccessException e) {
            Object[] args = new String[]{IDENTIFIER, this.m_sXSLT};
            throw new XTSCacheException("transformer.compileerror", args, e);
        }
        catch (InstantiationException e) {
            Object[] args = new String[]{IDENTIFIER, this.m_sXSLT};
            throw new XTSCacheException("transformer.compileerror", args, e);
        }
        catch (ClassNotFoundException e) {
            Object[] args = new String[]{IDENTIFIER, this.m_sXSLT};
            throw new XTSCacheException("transformer.compileerror", args, e);
        }
    }

    public void execute(XTSEnvironment env, Source source, Result result, String encoding, String mediaType) throws XTSCacheException {
        if (this.m_oTemplate == null) {
            Object[] args = new String[]{this.m_sXSLT};
            throw new XTSCacheException("instruction.request.cmtemplatefailed", args);
        }
        try {
            Transformer transformer = this.m_oTemplate.newTransformer();
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            if (mediaType != null) {
                transformer.setOutputProperty("media-type", mediaType);
            }
            if (this.m_oURIResolver != null) {
                transformer.setURIResolver(this.m_oURIResolver);
            }
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            Object[] args = new String[]{IDENTIFIER};
            throw new XTSCacheException("transformer.processerror", args, e);
        }
        catch (TransformerException e) {
            Object[] args = new String[]{IDENTIFIER};
            throw new XTSCacheException("transformer.processerror", args, e);
        }
    }

    public XMLFilter getXMLFilter() {
        return this.m_oXMLFilter;
    }

    public Templates getTemplate() {
        return this.m_oTemplate;
    }
}

