/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.request;

import com.cognos.xts.util.CharArrayReaderWriter;
import com.cognos.xts.util.soaputil;
import com.cognos.xts.util.xmlutil;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class SoapBodyContentFilter
extends XMLFilterImpl
implements LexicalHandler {
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final int BUFFER_SIZE = 4096;
    private static final char OPEN_BRACKET_START = '<';
    private static final char OPEN_BRACKET_END = '>';
    private static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    private static final char CLOSE_BRACKET_END = '>';
    private static final char[] PROCESSING_INSTRUCTION_START = new char[]{'<', '?'};
    private static final char[] PROCESSING_INSTRUCTION_END = new char[]{'?', '>'};
    private static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    private static final char EQUALS = '=';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final char[] EQUALS_QUOTE = new char[]{'=', '\"'};
    private static final char[] SPACE_XMLNS = new char[]{' ', 'x', 'm', 'l', 'n', 's'};
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};
    private XMLReader m_parent = null;
    private CharArrayReaderWriter m_recordBuf = null;
    private boolean m_record = false;
    private String m_currentEntity = null;
    private HashMap m_NSMap = null;
    private NamespaceSupport m_GlobalNSMap = new NamespaceSupport();
    private int m_curlevel = 0;
    private LexicalHandler m_lexicalHandler = null;

    public SoapBodyContentFilter() {
    }

    public SoapBodyContentFilter(XMLReader parent) {
        super(parent);
    }

    private void setup() {
        this.m_recordBuf = null;
        this.m_record = false;
        this.m_curlevel = 0;
        this.m_currentEntity = null;
        this.m_NSMap = null;
        this.m_GlobalNSMap.reset();
    }

    public Reader getBuffer() {
        if (this.m_recordBuf != null) {
            return this.m_recordBuf.convert();
        }
        return null;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.setup();
        super.getParent().setProperty(LEXICALHANDLER_PROPERTY, this);
        super.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.setup();
        super.parse(systemId);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(LEXICALHANDLER_PROPERTY)) {
            this.m_lexicalHandler = (LexicalHandler)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_GlobalNSMap.pushContext();
        this.m_curlevel = 0;
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_GlobalNSMap.popContext();
        super.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_GlobalNSMap.declarePrefix(prefix, uri);
        if (this.m_NSMap != null) {
            this.m_NSMap.put(prefix, uri);
        }
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        ++this.m_curlevel;
        this.m_GlobalNSMap.pushContext();
        boolean callparent = false;
        if (!this.m_record) {
            if (this.m_curlevel == 2 && localName.equals("Body") && uri.equals(soaputil.getSOAPNamespaceURI(11))) {
                this.m_record = true;
                this.m_recordBuf = new CharArrayReaderWriter(4096);
                this.m_NSMap = new HashMap();
                Enumeration<String> myEnum = this.m_GlobalNSMap.getPrefixes();
                while (myEnum.hasMoreElements()) {
                    String ns_prefix = myEnum.nextElement();
                    String ns_uri = this.m_GlobalNSMap.getURI(ns_prefix);
                    if (ns_prefix.equals("xml")) continue;
                    this.m_NSMap.put(ns_prefix, ns_uri);
                }
                callparent = true;
            }
        } else {
            try {
                this.m_recordBuf.write(60);
                this.m_recordBuf.write(qName);
                int attlen = atts.getLength();
                for (int i = 0; i < attlen; ++i) {
                    this.m_recordBuf.write(32);
                    this.m_recordBuf.write(atts.getQName(i));
                    this.m_recordBuf.write(EQUALS_QUOTE);
                    xmlutil.xmlencode(atts.getValue(i), this.m_recordBuf);
                    this.m_recordBuf.write(34);
                }
                if (!this.m_NSMap.isEmpty()) {
                    Iterator it = this.m_NSMap.entrySet().iterator();
                    String prefix = null;
                    Map.Entry pair = null;
                    while (it.hasNext()) {
                        this.m_recordBuf.write(SPACE_XMLNS);
                        pair = it.next();
                        prefix = (String)pair.getKey();
                        if (prefix.length() > 0) {
                            this.m_recordBuf.write(58);
                            this.m_recordBuf.write((String)pair.getKey());
                        }
                        this.m_recordBuf.write(EQUALS_QUOTE);
                        this.m_recordBuf.write((String)pair.getValue());
                        this.m_recordBuf.write(34);
                    }
                    this.m_NSMap.clear();
                }
                this.m_recordBuf.write(62);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage());
            }
            callparent = true;
        }
        if (callparent) {
            super.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean callparent = false;
        if (this.m_record) {
            if (this.m_curlevel == 2 && localName.equals("Body") && uri.equals(soaputil.getSOAPNamespaceURI(11))) {
                this.m_record = false;
                this.m_NSMap = null;
            } else {
                try {
                    this.m_recordBuf.write(CLOSE_BRACKET_START);
                    this.m_recordBuf.write(qName);
                    this.m_recordBuf.write(62);
                }
                catch (IOException e) {
                    throw new SAXException(e.getMessage());
                }
            }
            callparent = true;
        }
        this.m_GlobalNSMap.popContext();
        this.m_GlobalNSMap.popContext();
        this.m_GlobalNSMap.pushContext();
        --this.m_curlevel;
        if (callparent) {
            super.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_record) {
            try {
                if (this.m_currentEntity != null) {
                    this.m_recordBuf.write(xmlutil.outEntityReference(this.m_currentEntity, ch, start, length));
                } else {
                    this.m_recordBuf.write(ch, start, length);
                }
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage());
            }
            super.characters(ch, start, length);
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.m_record) {
            this.m_recordBuf.write(ch, start, length);
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_record) {
            try {
                this.m_recordBuf.write(PROCESSING_INSTRUCTION_START);
                this.m_recordBuf.write(target);
                this.m_recordBuf.write(32);
                this.m_recordBuf.write(data);
                this.m_recordBuf.write(PROCESSING_INSTRUCTION_END);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage());
            }
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.m_record) {
            try {
                this.m_recordBuf.write(CDATA_START);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage());
            }
        }
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.m_record) {
            try {
                this.m_recordBuf.write(CDATA_END);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage());
            }
        }
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(ch, start, length);
        }
    }
}

