/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.request;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.baltic.request.CMTemplate;
import com.cognos.xts.baltic.request.CMTemplateFactory;
import com.cognos.xts.baltic.request.XTSCMResult;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.xmlutil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XTSCMRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final int ENVELOPE_BUFFER_SIZE = 4096;
    private static final int ENVELOPE_READ_SIZE = 1024;
    private static final String ERR_CM = "Content Manager";
    public static final String REQUEST_HREF_CM = "cm://";
    public static final String CM_CM = "cm";
    public static final String ATT_NM_PREXSLT = "prexslt";
    public static final String ATT_NM_POSTXSLT = "postxslt";
    private String m_sIdentifier = null;
    private String m_cmURL = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_cmURL = PropertiesManager.getInstance().getProperty("cm.url");
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        boolean includeEnvelope = false;
        String responseEnvelope = UXTSInstructionUtils.getParameter("responseEnvelope", instParams);
        if (responseEnvelope != null && responseEnvelope.equals("true")) {
            includeEnvelope = true;
        }
        return this.handleCMRequest(env, instAtts, instParams, body, includeEnvelope);
    }

    private IXTSInstructionResult handleCMRequest(XTSEnvironment env, Map instAtts, Map instParams, Reader body, boolean includeEnvelope) throws XTSInstructionException {
        Object bodyGenerator;
        String prexslt = UXTSInstructionUtils.getParameter(ATT_NM_PREXSLT, instParams);
        if (prexslt != null && prexslt.length() > 0) {
            ByteArrayIOStream requestBody = new ByteArrayIOStream(4096);
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
                pLogger.log(env, 6, this.getClass().getName(), "handleCMRequest", "sub-timer: start pre-transform");
                pLogger.starttimer();
            }
            try {
                HashMap<String, Object> atts = new HashMap<String, Object>();
                atts.put("xslt", prexslt);
                URIResolver uriResolver = (URIResolver)instParams.get("uriResolver");
                if (uriResolver != null) {
                    atts.put("urlResolver", uriResolver);
                }
                CMTemplate cmTemplate = null;
                String cache = (String)instAtts.get("cache");
                if (cache != null && cache.equals("false")) {
                    cmTemplate = new CMTemplate();
                    cmTemplate.initialize(env, atts);
                } else {
                    cmTemplate = (CMTemplate)CMTemplateFactory.getInstance().getObject(env, atts);
                }
                if (cmTemplate == null) {
                    Object[] args = new String[]{prexslt};
                    throw new XTSInstructionException("instruction.request.cmtemplatefailed", args);
                }
                StreamSource source = new StreamSource(body);
                StreamResult result = new StreamResult(requestBody);
                cmTemplate.execute(env, source, result, "UTF-8", "text/xml");
                bodyGenerator = new ByteArrayIOStreamXSLTMsgBodyGenerator(requestBody, true);
            }
            catch (XTSCacheException e) {
                Object[] args = new String[]{prexslt};
                throw new XTSInstructionException("instruction.request.cmtemplatefailed", args, e);
            }
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(env, 1, this.getClass().getName(), "handleCMRequest", "sub-timer: done pre-transform");
            }
        } else {
            bodyGenerator = new ReaderXSLTMsgBodyGenerator(body);
        }
        if (XTSAuditLoggerManager.getInstance().isEnabled[3][1]) {
            try {
                IXTSLogger logger = XTSAuditLoggerManager.getInstance().getLogger(3, 1);
                if (logger != null) {
                    ByteArrayIOStream bio = new ByteArrayIOStream(4096);
                    bodyGenerator.writeBody(bio);
                    logger.log(env, 2, new String(bio.toByteArray()), null, null);
                    bodyGenerator = new ByteArrayIOStreamXSLTMsgBodyGenerator(bio, false);
                }
            }
            catch (IOException e) {
                throw new XTSInstructionException("instruction.failedtocopyreader", e);
            }
        }
        ServerConnection con = this.sendBusEnvelope(env, (MsgBodyGenerator)bodyGenerator, instAtts, instParams);
        return new XTSCMResult(env, con, instAtts, instParams, includeEnvelope);
    }

    private IXTSInstructionResult handleCMQueryRequest(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        throw new UnsupportedOperationException("Coming soon to a theater near you!");
    }

    private ServerConnection sendBusEnvelope(XTSEnvironment env, MsgBodyGenerator bodyGenerator, Map instAtts, Map instParams) throws XTSInstructionException {
        ServerConnection conn = DispatcherConnectionManager.getContentManagerConnection();
        if (conn == null) {
            Object[] args = new String[]{CM_CM};
            throw new XTSInstructionException("protocol.nobusconnection", args);
        }
        try {
            String soapAction = UXTSInstructionUtils.getParameter("soapAction", instParams);
            if (soapAction == null) {
                soapAction = "";
            }
            conn.setRequestHeader("SOAPAction", soapAction);
            conn.addRequestHeader("Content-Type", "text/xml; charset=utf-8");
            conn.addRequestHeader("Connection", "Keep-Alive");
            conn.setRequestBodySource(bodyGenerator);
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
                pLogger.log(env, 6, this.getClass().getName(), "sendBusEnvelope", "sub-timer: start connection-execute");
                pLogger.starttimer();
            }
            conn.sendRequest(this.m_cmURL);
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(env, 1, this.getClass().getName(), "sendBusEnvelope", "sub-timer: done connection-execute");
            }
            return conn;
        }
        catch (IOException e) {
            conn.release();
            Object[] args = new String[]{ERR_CM};
            throw new XTSInstructionException("protocol.bus.requestfailed.prod", args, e);
        }
    }

    private class ReaderXSLTMsgBodyGenerator
    implements MsgBodyGenerator {
        private Reader envelope;

        ReaderXSLTMsgBodyGenerator(Reader envelope) {
            this.envelope = envelope;
        }

        public boolean rewind() {
            return false;
        }

        public void writeBody(OutputStream outputstream) throws IOException {
            outputstream.write(xmlutil.m_defaultXMLHeaderByte);
            outputstream.flush();
            BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter(outputstream, "UTF-8"));
            char[] buf = new char[1024];
            int bytesRead = this.envelope.read(buf, 0, 1024);
            while (bytesRead != -1) {
                bufWriter.write(buf, 0, bytesRead);
                bytesRead = this.envelope.read(buf, 0, 1024);
            }
            bufWriter.flush();
        }
    }

    private class ByteArrayIOStreamXSLTMsgBodyGenerator
    implements MsgBodyGenerator {
        private ByteArrayIOStream envelope;
        private boolean writeDefaultXMLHeader;

        ByteArrayIOStreamXSLTMsgBodyGenerator(ByteArrayIOStream envelope, boolean writeDefaultXMLHeader) {
            this.envelope = envelope;
            this.writeDefaultXMLHeader = writeDefaultXMLHeader;
        }

        public boolean rewind() {
            return false;
        }

        public void writeBody(OutputStream outputstream) throws IOException {
            if (this.writeDefaultXMLHeader) {
                outputstream.write(xmlutil.m_defaultXMLHeaderByte);
            }
            outputstream.write(this.envelope.getBuf(), 0, this.envelope.getBufSize());
        }
    }
}

