/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.request;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.baltic.request.CMTemplate;
import com.cognos.xts.baltic.request.CMTemplateFactory;
import com.cognos.xts.baltic.request.SoapBodyContentFilter;
import com.cognos.xts.baltic.request.SoapEntityFilter;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.request.XTSBusException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CharArrayReaderWriter;
import com.cognos.xts.util.MultipartMimeInputStream;
import com.cognos.xts.util.message;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.Header;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XTSCMResult
implements IXTSOutputableInstructionResult {
    private static final int BUFFER_SIZE = 4096;
    private static final String MULTIPART = "multipart";
    private static final String BOUNDARY = "boundary";
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private ContentType m_contentType;
    private ServerConnection m_conn;
    private Reader m_result;
    private InputStream m_soapAttIn;
    private Reader m_soapHdrReader;
    private boolean m_bConnected;

    private XTSCMResult() {
        this.m_contentType = null;
        this.m_conn = null;
        this.m_result = null;
        this.m_soapAttIn = null;
        this.m_soapHdrReader = null;
        this.m_bConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XTSCMResult(XTSEnvironment env, ServerConnection conn, Map instAtts, Map instParams, boolean includeEnvelope) throws XTSInstructionException, XTSBusException {
        ContentType ct;
        IXTSLogger pLogger;
        block55: {
            InputStream soapEnvIn;
            block54: {
                String contentType;
                this.m_contentType = null;
                this.m_conn = null;
                this.m_result = null;
                this.m_soapAttIn = null;
                this.m_soapHdrReader = null;
                this.m_bConnected = false;
                pLogger = null;
                if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
                    pLogger.log(env, 6, this.getClass().getName(), "XTSCMResult", "sub-timer: start post parsing");
                    pLogger.starttimer();
                }
                this.m_conn = conn;
                InputStream in = null;
                try {
                    in = this.m_conn.getInputStream();
                }
                catch (IOException e) {
                    this.m_conn.release();
                    Object[] args = new String[]{"cm"};
                    throw new XTSInstructionException("protocol.bus.responsefailed", args, e);
                }
                ct = null;
                try {
                    contentType = this.m_conn.getResponseContentType();
                }
                catch (IllegalStateException e) {
                    contentType = null;
                }
                if (contentType != null) {
                    try {
                        ct = new ContentType(contentType);
                    }
                    catch (ParseException e) {
                        this.m_conn.release();
                        Object[] args = new Object[]{contentType, "cm"};
                        throw new XTSInstructionException("protocol.bus.invalidcontenttype", args, e);
                    }
                }
                soapEnvIn = null;
                try {
                    if (ct != null && ct.getPrimaryType().equalsIgnoreCase(MULTIPART)) {
                        String boundary = ct.getParameter(BOUNDARY);
                        String boundary_start = "--" + boundary;
                        String boundary_end = boundary_start + "--";
                        String line = message.getFirstNonWhiteSpaceLine(in);
                        if (line == null) {
                            Object[] args = new Object[]{"cm"};
                            throw new XTSInstructionException("protocol.bus.endofstream", args);
                        }
                        if (!line.equals(boundary_start)) {
                            Object[] args = new Object[]{"cm"};
                            throw new XTSInstructionException("protocol.bus.invalidboundary", args);
                        }
                        InternetHeaders hd = null;
                        try {
                            hd = new InternetHeaders(in);
                        }
                        catch (MessagingException e) {
                            Object[] args = new Object[]{"cm"};
                            throw new XTSInstructionException("protocol.bus.invalidmimeheaders", args, e);
                        }
                        String bodySize = hd.getHeader("Content-Length", null);
                        byte[] buf = null;
                        if (bodySize != null) {
                            int size = Integer.parseInt(bodySize);
                            buf = new byte[size];
                            in.read(buf, 0, size);
                            soapEnvIn = new ByteArrayInputStream(buf);
                            do {
                                if ((buf = message.readLine(in)) == null) {
                                    Object[] args = new Object[]{"cm"};
                                    throw new XTSInstructionException("protocol.bus.endofstream", args);
                                }
                                line = new String(buf, "UTF-8");
                            } while (!(line = line.trim()).equals(boundary_start) && !line.equals(boundary_end));
                        } else {
                            ByteArrayIOStream out = new ByteArrayIOStream(4096);
                            while (true) {
                                if ((buf = message.readLine(in)) == null) {
                                    Object[] args = new Object[]{"cm"};
                                    throw new XTSInstructionException("protocol.bus.endofstream", args);
                                }
                                line = new String(buf, "UTF-8");
                                if ((line = line.trim()).equals(boundary_start) || line.equals(boundary_end)) break;
                                out.write(buf);
                            }
                            soapEnvIn = out.convert();
                        }
                        if (!line.equals(boundary_end)) {
                            this.m_soapAttIn = in;
                        }
                        break block54;
                    }
                    soapEnvIn = in;
                }
                catch (IOException e) {
                    this.m_conn.release();
                    Object[] args = new String[]{"cm"};
                    throw new XTSInstructionException("protocol.bus.responsefailed", args, e);
                }
                catch (XTSInstructionException e) {
                    this.m_conn.release();
                    throw e;
                }
            }
            if (XTSAuditLoggerManager.getInstance().isEnabled[3][1]) {
                StringBuffer buf = new StringBuffer();
                try {
                    soapEnvIn = UXTSInstructionUtils.copyInputStream(soapEnvIn, buf);
                    IXTSLogger logger = XTSAuditLoggerManager.getInstance().getLogger(3, 1);
                    if (logger != null) {
                        logger.log(env, 3, buf.toString(), null, null);
                    }
                }
                catch (IOException e) {
                    throw new XTSInstructionException("instruction.failedtocopyreader", e);
                }
            }
            AXTSPoolObject parser = null;
            try {
                parser = XTSSAXParserPool.getInstance().acquire();
            }
            catch (XTSException e) {
                throw new XTSInstructionException("instruction.request.saxreaderfailed", e);
            }
            try {
                Reader faultReader;
                XMLReader reader = null;
                try {
                    reader = ((SAXParser)parser.get()).getXMLReader();
                }
                catch (SAXException e) {
                    throw new XTSInstructionException("instruction.request.saxreaderfailed", e);
                }
                SoapEntityFilter faultFilter = new SoapEntityFilter("Fault", 3);
                faultFilter.setParent(reader);
                XMLFilterImpl filter = faultFilter;
                SoapEntityFilter hdrFilter = new SoapEntityFilter("Header", 2);
                hdrFilter.setParent(filter);
                filter = hdrFilter;
                SoapBodyContentFilter bcFilter = new SoapBodyContentFilter();
                bcFilter.setParent(filter);
                filter = bcFilter;
                String postxslt = UXTSInstructionUtils.getParameter("postxslt", instParams);
                if (postxslt != null && postxslt.length() > 0) {
                    try {
                        CharArrayReaderWriter rw = new CharArrayReaderWriter(4096);
                        HashMap<String, Object> atts = new HashMap<String, Object>();
                        atts.put("xslt", postxslt);
                        URIResolver uriResolver = (URIResolver)instParams.get("uriResolver");
                        if (uriResolver != null) {
                            atts.put("urlResolver", uriResolver);
                        }
                        CMTemplate cmTemplate = null;
                        String cache = (String)instAtts.get("cache");
                        if (cache != null && cache.equals("false")) {
                            cmTemplate = new CMTemplate();
                            cmTemplate.initialize(env, atts);
                        } else {
                            cmTemplate = (CMTemplate)CMTemplateFactory.getInstance().getObject(env, atts);
                        }
                        if (cmTemplate == null) {
                            Object[] args = new String[]{postxslt};
                            throw new XTSInstructionException("instruction.request.cmtemplatefailed", args);
                        }
                        String encoding = UXTSInstructionUtils.getParameter("encoding", instParams);
                        String mediaType = UXTSInstructionUtils.getParameter("mediaType", instParams);
                        SAXSource source = new SAXSource(filter, new InputSource(soapEnvIn));
                        StreamResult result = new StreamResult(rw);
                        cmTemplate.execute(env, source, result, encoding, mediaType);
                        this.m_result = rw.convert();
                    }
                    catch (XTSCacheException e) {
                        Object[] args = new String[]{postxslt};
                        throw new XTSInstructionException("instruction.request.cmtemplatefailed", args, e);
                    }
                }
                try {
                    bcFilter.parse(new InputSource(soapEnvIn));
                    this.m_result = bcFilter.getBuffer();
                }
                catch (SAXException e) {
                    throw new XTSInstructionException("instruction.request.parseresponsefailed", e);
                }
                catch (IOException e) {
                    throw new XTSInstructionException("instruction.request.parseresponsefailed", e);
                }
                if (hdrFilter != null) {
                    this.m_soapHdrReader = hdrFilter.getBuffer();
                }
                if (faultFilter == null || (faultReader = faultFilter.getBuffer()) == null) break block55;
                this.m_conn.release();
                StringReader hdrReader = null;
                StringBuffer buf = new StringBuffer();
                if (this.m_soapHdrReader != null) {
                    try {
                        this.m_soapHdrReader = UXTSInstructionUtils.copyReader(this.m_soapHdrReader, buf);
                        hdrReader = new StringReader(buf.toString());
                    }
                    catch (IOException e) {
                        throw new XTSInstructionException("instruction.failedtocopyreader", e);
                    }
                }
                throw new XTSBusException("request.soapfault", faultReader, hdrReader, 11, includeEnvelope);
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
        }
        if (this.m_soapAttIn == null) {
            this.m_conn.release();
        } else {
            try {
                this.m_soapAttIn = new MultipartMimeInputStream(this.m_soapAttIn, ct.getParameter(BOUNDARY), true);
            }
            catch (UnsupportedEncodingException e) {
                this.m_conn.release();
                Object[] args = new String[]{"cm"};
                throw new XTSInstructionException("protocol.unsupportedencodingexception", args, e);
            }
            catch (IOException e) {
                this.m_conn.release();
                throw new XTSInstructionException("protocol.ioexception", e);
            }
            this.m_bConnected = true;
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(env, 1, this.getClass().getName(), "XTSCMResult", "sub-timer: done post parsing");
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_result.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_result.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_result = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_result);
    }

    @Override
    public void release() throws XTSInstructionException {
        if (this.m_bConnected) {
            this.m_conn.release();
            this.m_bConnected = false;
        }
        try {
            if (this.m_result != null) {
                this.m_result.close();
                this.m_result = null;
            }
            if (this.m_soapAttIn != null) {
                this.m_soapAttIn.close();
                this.m_soapAttIn = null;
            }
            if (this.m_soapHdrReader != null) {
                this.m_soapHdrReader.close();
                this.m_soapHdrReader = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    public Reader getSOAPHeader() {
        return this.m_soapHdrReader;
    }

    @Override
    public boolean attachmentsSupported() {
        return true;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 31;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return this.m_soapAttIn;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        InternetHeaders iHdrs = new InternetHeaders();
        Header[] hdrs = this.m_conn.getResponseHeaders();
        Header hdr = null;
        for (int i = 0; i < hdrs.length; ++i) {
            hdr = hdrs[i];
            String hdrName = hdr.getName();
            if (XTSOutputSpecUtils.isMimeHeader(hdrName)) continue;
            iHdrs.addHeader(hdrName, hdr.getValue());
        }
        return iHdrs;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }
}

