/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.security;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.accman.jcam.crypto.ReportSpecProtectionSession;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSFastCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.security.IXTSCacheSecurity;
import com.cognos.xts.security.XTSSecurityException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;

public final class CognosCAM
extends AXTSFastCacheObject
implements IXTSCacheSecurity {
    private static final String IDENTIFIER = "cognos.cam";
    private static final String INIT_PARAM = "<initializeDocument><serviceID>CC</serviceID></initializeDocument>";
    private CAMFactory m_oCAMFactory = null;

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected void initialize_Impl(XTSEnvironment env, Map atts) throws XTSCacheException {
        try {
            this.m_oCAMFactory = new CAMFactory();
            if (this.m_oCAMFactory != null) {
                this.m_oCAMFactory.initialize(INIT_PARAM.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new XTSCacheException("cognoscam.initializefailed", e);
        }
        catch (CAMCryptoException e) {
            throw new XTSCacheException("cognoscam.initializefailed", e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_oCAMFactory != null) {
            this.m_oCAMFactory.terminate();
        }
        this.m_oCAMFactory = null;
    }

    @Override
    public byte[] encrypt(XTSEnvironment env, byte[] source, Map paramMap) throws XTSSecurityException {
        if (this.m_oCAMFactory == null) {
            throw new XTSSecurityException("cognoscam.uninitialize");
        }
        byte[] result = null;
        try {
            EncryptingSession session = this.m_oCAMFactory.createEncryptingSession();
            if (session == null) {
                throw new XTSSecurityException("cognoscam.emptysession");
            }
            result = session.encryptData(source);
        }
        catch (CAMCryptoException e) {
            throw new XTSSecurityException("cognoscam.encryptexception", e);
        }
        return result;
    }

    @Override
    public byte[] decrypt(XTSEnvironment env, byte[] source, Map paramMap) throws XTSSecurityException {
        if (this.m_oCAMFactory == null) {
            throw new XTSSecurityException("cognoscam.uninitialize");
        }
        byte[] result = null;
        try {
            EncryptingSession session = this.m_oCAMFactory.createEncryptingSession();
            if (session == null) {
                throw new XTSSecurityException("cognoscam.emptysession");
            }
            result = session.decryptData(source);
        }
        catch (CAMCryptoException e) {
            throw new XTSSecurityException("cognoscam.decryptexception", e);
        }
        return result;
    }

    @Override
    public HttpClient getHttpClient(XTSEnvironment env, String host, int port, boolean secure, Map paramMap) throws XTSSecurityException {
        if (this.m_oCAMFactory == null) {
            throw new XTSSecurityException("cognoscam.uninitialize");
        }
        try {
            return this.m_oCAMFactory.createHttpClient(host, port, secure);
        }
        catch (CAMCryptoException e) {
            String sSecure = secure ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            String sPort = Integer.toString(port);
            Object[] args = new String[]{host, sPort, sSecure};
            throw new XTSSecurityException("cognoscam.httpclientexception", args, e);
        }
    }

    @Override
    public byte[] signReportSpec(XTSEnvironment env, byte[] source, Map paramMap) throws XTSSecurityException {
        if (this.m_oCAMFactory == null) {
            throw new XTSSecurityException("cognoscam.uninitialize");
        }
        byte[] result = null;
        try {
            ReportSpecProtectionSession reportSpecProtector = this.m_oCAMFactory.createReportSpecProtectionSession();
            if (reportSpecProtector == null) {
                throw new XTSSecurityException("cognoscam.emptysession");
            }
            reportSpecProtector.setSpec(source);
            result = reportSpecProtector.protectData();
        }
        catch (CAMCryptoException e) {
            throw new XTSSecurityException("cognoscam.signspecexception", e);
        }
        return result;
    }

    @Override
    public boolean getRequestExternal(XTSEnvironment env, byte[] passport, byte[] secureState, Map paramMap) throws XTSSecurityException {
        if (this.m_oCAMFactory == null) {
            throw new XTSSecurityException("cognoscam.uninitialize");
        }
        boolean signSpecification = false;
        try {
            boolean validSecureState;
            SecureStateSession session = this.m_oCAMFactory.createSecureStateSession(passport, secureState);
            if (session != null && (validSecureState = session.verifySecureStateToken())) {
                signSpecification = session.getRequestExternal();
            }
        }
        catch (CAMCryptoException cAMCryptoException) {
            // empty catch block
        }
        return signSpecification;
    }

    @Override
    public boolean verifyUserCapabilities(String token, String userCapabilities, String passportID) throws XTSSecurityException {
        if ((userCapabilities == null || "".equals(userCapabilities)) && (token == null || "".equals(token))) {
            return true;
        }
        if (this.m_oCAMFactory == null) {
            throw new XTSSecurityException("cognoscam.uninitialize");
        }
        try {
            GenericTrustedSession gts = null;
            gts = this.m_oCAMFactory.createGenericTrustedSession();
            return gts.verifyTrustToken(token.getBytes("UTF-8"), userCapabilities.getBytes("UTF-8"), passportID);
        }
        catch (CAMCryptoException e) {
            throw new XTSSecurityException("cognoscam.sessioncapabilityexception", e);
        }
        catch (Exception e) {
            throw new XTSSecurityException("cognoscam.sessioncapabilityexception", e);
        }
    }
}

