/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.validation;

import com.cognos.validator.api.Document;
import com.cognos.validator.api.IImportResolver;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.baltic.validation.ImportResolver;
import com.cognos.xts.baltic.validation.InputParameters;
import com.cognos.xts.common.cache.AXTSFastCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.validation.IXTSCacheValidator;
import com.cognos.xts.validation.XTSValidatorException;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class CognosValidator
extends AXTSFastCacheObject
implements IXTSCacheValidator {
    private static final String IDENTIFIER = "cognos.validator";
    private static final String ENABLE = "validation.enable";
    private static final String MANDATORY = "validation.mandatory";
    private ValidatorFactory m_oValidatorFactory = null;
    private ImportResolver m_oImportResolver = null;
    private boolean enabled = true;

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected void initialize_Impl(XTSEnvironment env, Map atts) throws XTSCacheException {
        String sEnabled = PropertiesManager.getInstance().getProperty(ENABLE);
        if (sEnabled != null && !sEnabled.equals("true")) {
            this.enabled = false;
        } else {
            boolean mandatory = false;
            String sMandatory = PropertiesManager.getInstance().getProperty(MANDATORY);
            if (sMandatory != null && sMandatory.equals("true")) {
                mandatory = true;
            }
            try {
                this.m_oValidatorFactory = ValidatorFactory.newInstance();
                if (this.m_oValidatorFactory != null) {
                    this.m_oValidatorFactory.put(0, mandatory);
                    this.m_oImportResolver = new ImportResolver();
                    this.m_oValidatorFactory.addImportResolver((IImportResolver)this.m_oImportResolver);
                }
            }
            catch (ValidatorException e) {
                throw new XTSCacheException("cognosvalidator.initializefailed", e);
            }
        }
    }

    private Document loadDoc(String namespace) throws XTSValidatorException {
        Document doc = null;
        try {
            doc = this.m_oValidatorFactory.createDocument();
            if (!doc.loadFromNamespace(namespace)) {
                Reader reader = this.m_oImportResolver.xmlDocument(namespace);
                doc.loadFromXML(reader);
            }
        }
        catch (ValidatorException e) {
            throw new XTSValidatorException("cognosvalidator.verifyfailed", e);
        }
        return doc;
    }

    @Override
    public void addLocation(String namespace, String fileName) {
        if (this.m_oImportResolver != null) {
            this.m_oImportResolver.addLocation(namespace, fileName);
        }
    }

    @Override
    public void verify(String namespace, List inputParams) throws XTSValidatorException {
        if (this.enabled) {
            try {
                Document doc = this.loadDoc(namespace);
                VerifySession verifySession = this.m_oValidatorFactory.createVerifySession(doc);
                InputParameters inputParameters = new InputParameters(inputParams);
                verifySession.verify((IParameterUpdater)inputParameters);
            }
            catch (VerifyException e) {
                StringBuffer msg;
                IXTSLogger logger;
                if (XTSAuditLoggerManager.getInstance().isEnabled[0][1] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 1)) != null) {
                    msg = new StringBuffer();
                    msg.append("cognosvalidator.securityrejection");
                    msg.append("\n [failure details]").append(e.getFailureDetails());
                    msg.append("\n [validator details]" + e.getValidatorDetails());
                    logger.log(null, 2, msg.toString(), null, null);
                }
                IXTSLogger traceLogger1 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                    msg = new StringBuffer();
                    msg.append("cognosvalidator.securityrejection");
                    msg.append("\n [failure details]").append(e.getFailureDetails());
                    msg.append("\n [validator details]" + e.getValidatorDetails());
                    traceLogger1.log(null, 8, msg.toString(), null, null);
                }
                throw new XTSValidatorException("cognosvalidator.securityrejection");
            }
            catch (ValidatorException e) {
                StringBuffer msg;
                IXTSLogger logger;
                if (XTSAuditLoggerManager.getInstance().isEnabled[0][1] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 1)) != null) {
                    msg = new StringBuffer();
                    msg.append("cognosvalidator.verifyfailed");
                    msg.append(e.getMessage());
                    logger.log(null, 2, msg.toString(), null, null);
                }
                IXTSLogger traceLogger1 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                    msg = new StringBuffer();
                    msg.append("cognosvalidator.verifyfailed");
                    msg.append(e.getMessage());
                    traceLogger1.log(null, 8, msg.toString(), null, null);
                }
                throw new XTSValidatorException("cognosvalidator.verifyfailed", e);
            }
        }
    }

    @Override
    public void prepare(String namespace, List inputParams) throws XTSValidatorException {
        if (this.enabled) {
            try {
                Document doc = this.loadDoc(namespace);
                VerifySession verifySession = this.m_oValidatorFactory.createVerifySession(doc);
                InputParameters inputParameters = new InputParameters(inputParams);
                verifySession.prepare((IParameterUpdater)inputParameters);
            }
            catch (ValidatorException e) {
                StringBuffer msg;
                IXTSLogger logger;
                if (XTSAuditLoggerManager.getInstance().isEnabled[0][1] && (logger = XTSAuditLoggerManager.getInstance().getLogger(0, 1)) != null) {
                    msg = new StringBuffer();
                    msg.append("cognosvalidator.preparefailed");
                    msg.append(e.getMessage());
                    logger.log(null, 2, msg.toString(), null, null);
                }
                IXTSLogger traceLogger1 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
                    msg = new StringBuffer();
                    msg.append("cognosvalidator.preparefailed");
                    msg.append(e.getMessage());
                    traceLogger1.log(null, 8, msg.toString(), null, null);
                }
                throw new XTSValidatorException("cognosvalidator.preparefailed", e);
            }
        }
    }
}

