/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.baltic.validation;

import com.cognos.validator.api.IParameter;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.util.List;
import org.dom4j.Element;

public class InputParameters
implements IParameterUpdater {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private List m_paramNodeList = null;
    private int m_index = -1;
    private int m_listSize = 0;
    private boolean m_useAttr = false;

    private InputParameters() {
    }

    public InputParameters(List paramNodeList) {
        Element curVar;
        this.m_paramNodeList = paramNodeList;
        this.m_index = 0;
        if (this.m_paramNodeList != null) {
            this.m_listSize = paramNodeList.size();
        }
        if (this.m_listSize > 0 && (curVar = (Element)this.m_paramNodeList.get(this.m_index)).attribute(NAME) != null) {
            this.m_useAttr = true;
        }
    }

    public boolean hasNext() {
        return this.m_index < this.m_listSize;
    }

    public IParameter next() {
        if (this.m_listSize > 0 && this.m_index < this.m_listSize) {
            Element curVar = (Element)this.m_paramNodeList.get(this.m_index);
            ++this.m_index;
            if (curVar != null) {
                String sName = null;
                if (this.m_useAttr) {
                    sName = curVar.attributeValue(NAME);
                } else {
                    Element nameEle = curVar.element(NAME);
                    if (nameEle != null) {
                        sName = nameEle.getText();
                    }
                }
                if (sName != null) {
                    Element valueEle = curVar.element(VALUE);
                    if (valueEle != null) {
                        return new Parameter(sName, valueEle);
                    }
                    if (this.m_useAttr) {
                        return new Parameter(sName, curVar);
                    }
                }
            }
        }
        IXTSLogger traceLogger1 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[0][0] && (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) != null) {
            traceLogger1.log(null, 8, "XTS Error:  Error with input parameter list", null, null);
        }
        return null;
    }

    public void iterator() {
        this.m_index = 0;
    }

    private class Parameter
    implements IParameter {
        private String m_name = null;
        private String[] m_values = null;
        private Element m_node = null;

        public Parameter(String name, Element elem) {
            this.m_name = name;
            this.m_values = new String[1];
            if (elem != null) {
                this.m_values[0] = elem.getText();
                this.m_node = elem;
            }
        }

        public String name() {
            return this.m_name;
        }

        public String[] values() {
            return this.m_values;
        }

        public void setValues(String[] values) {
            this.m_values = values;
            if (this.m_node != null) {
                this.m_node.setText(this.m_values[0]);
            }
        }
    }
}

