/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.blockprocessor;

import com.cognos.xts.blockprocessor.IXTSJavaBlock;
import com.cognos.xts.blockprocessor.XTSBlockProcessorException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class AXTSJavaBlock
extends DefaultHandler
implements LexicalHandler,
IXTSJavaBlock {
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected static final Object m_dummy = new Object();
    protected String m_id = null;
    protected ThreadLocal m_result = new ThreadLocal();
    protected ThreadLocal m_contentHandler = new ThreadLocal();
    protected ThreadLocal m_lexicalHandler = new ThreadLocal();
    protected ThreadLocal m_activate = new ThreadLocal();

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public void initialize(String blkid) throws XTSBlockProcessorException {
        this.m_id = blkid;
    }

    protected void setFireEvents(boolean fire) {
        this.m_activate.set(fire ? m_dummy : null);
    }

    protected boolean isFireEvents() {
        return this.m_activate.get() != null;
    }

    @Override
    public void execute(Source source, Result result) throws XTSBlockProcessorException {
        if (!(result instanceof SAXResult)) {
            throw new UnsupportedOperationException("blkprocessor.nonsaxresult");
        }
        SAXResult saxResult = (SAXResult)result;
        this.m_result.set(saxResult);
        this.m_contentHandler.set(saxResult.getHandler());
        this.m_lexicalHandler.set(saxResult.getLexicalHandler());
        this.setFireEvents(false);
        if (source instanceof SAXSource) {
            this.executeSAXSource((SAXSource)source, result);
        } else if (source instanceof StreamSource) {
            this.executeStreamSource((StreamSource)source, result);
        } else if (source instanceof DOMSource) {
            this.executeDOMSource((DOMSource)source, result);
        } else {
            throw new XTSBlockProcessorException("blkprocessor.unknownsource");
        }
    }

    protected void executeSAXSource(SAXSource source, Result result) throws XTSBlockProcessorException {
        XMLReader reader = source.getXMLReader();
        InputSource input = source.getInputSource();
        try {
            reader.setContentHandler(this);
            reader.setProperty(LEXICAL_HANDLER_PROPERTY, this);
            reader.parse(input);
        }
        catch (Exception e) {
            throw new XTSBlockProcessorException("blkprocessor.executefailed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStreamSource(StreamSource source, Result result) throws XTSBlockProcessorException {
        try {
            InputSource input = null;
            InputStream inputStream = source.getInputStream();
            if (inputStream == null) {
                Reader inputReader = source.getReader();
                if (inputReader == null) {
                    String inputid = source.getSystemId();
                    if (inputid != null) {
                        input = new InputSource(inputid);
                    }
                } else {
                    input = new InputSource(inputReader);
                }
            } else {
                input = new InputSource(inputStream);
            }
            if (input == null) {
                throw new XTSBlockProcessorException("blkprocessor.missinginputsource");
            }
            AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
            try {
                XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                reader.setProperty(LEXICAL_HANDLER_PROPERTY, this);
                reader.setContentHandler(this);
                reader.parse(input);
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
        }
        catch (Exception e) {
            throw new XTSBlockProcessorException("blkprocessor.executefailed", e);
        }
    }

    protected void executeDOMSource(DOMSource source, Result result) throws XTSBlockProcessorException {
        throw new UnsupportedOperationException("blkprocessor.domsource");
    }

    @Override
    public void terminate() throws XTSBlockProcessorException {
    }

    @Override
    public void startDocument() throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        ContentHandler handler;
        if (this.isFireEvents() && (handler = (ContentHandler)this.m_contentHandler.get()) != null) {
            handler.skippedEntity(name);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        LexicalHandler handler;
        if (this.isFireEvents() && (handler = (LexicalHandler)this.m_lexicalHandler.get()) != null) {
            handler.comment(ch, start, length);
        }
    }
}

