/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.blockprocessor;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.blockprocessor.IXTSBlockProcessor;
import com.cognos.xts.blockprocessor.XTSBlockProcessorException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Element;
import org.dom4j.Namespace;

public final class JDBlockProcessor
implements IXTSBlockProcessor {
    public static final String MORPHLET_PACKAGE = "com.cognos.xts.morphlets";
    private static final String XSLT_CLASS_NAME = "jd.xml.xslt.trax.TransformerFactoryImpl";
    private static Object m_oMutex = new Object();
    private Templates m_oCachedTemplate = null;
    private String m_sIdentifier = null;
    private URIResolver m_oUriResolver = null;
    private String m_sSource = null;

    @Override
    public void initialize(String identifier) throws XTSBlockProcessorException {
        this.m_sIdentifier = identifier;
        this.m_oUriResolver = null;
        this.m_oCachedTemplate = null;
        this.m_sSource = null;
    }

    @Override
    public void compile(XTSEnvironment env, Element block, URIResolver uriResolver, String blkId) throws XTSBlockProcessorException {
        this.m_oUriResolver = uriResolver;
        if (this.m_oCachedTemplate != null) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSBlockProcessorException("blkprocessor.alreadycompiled", args);
        }
        List elelist = block.elements();
        if (elelist.size() != 1) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSBlockProcessorException("blkprocessor.multieleexception", args);
        }
        try {
            Element stylesheetElement = (Element)elelist.get(0);
            List nsList = block.declaredNamespaces();
            nsList.add(block.getNamespace());
            Namespace ns = null;
            List stylesheetNSList = stylesheetElement.declaredNamespaces();
            stylesheetNSList.add(stylesheetElement.getNamespace());
            Namespace stylesheetNS = null;
            for (int k = 0; k < nsList.size(); ++k) {
                ns = (Namespace)nsList.get(k);
                boolean bFound = false;
                for (int j = 0; j < stylesheetNSList.size() && !bFound; ++j) {
                    stylesheetNS = (Namespace)stylesheetNSList.get(j);
                    if (!stylesheetNS.getPrefix().equals(ns.getPrefix())) continue;
                    bFound = true;
                }
                if (bFound) continue;
                stylesheetElement = stylesheetElement.addNamespace(ns.getPrefix(), ns.getURI());
            }
            this.m_sSource = stylesheetElement.asXML();
            StreamSource xsltsrc = new StreamSource(new StringReader(this.m_sSource));
            xsltsrc.setSystemId("xts://" + blkId);
            TransformerFactory factory = (TransformerFactory)Class.forName(XSLT_CLASS_NAME).newInstance();
            factory.setURIResolver(this.m_oUriResolver);
            this.m_oCachedTemplate = factory.newTemplates(xsltsrc);
            String sDebugEnable = PropertiesManager.getInstance().getProperty("option.debugenable");
            if (sDebugEnable == null || !sDebugEnable.equals("true")) {
                this.m_sSource = null;
            }
        }
        catch (TransformerConfigurationException e) {
            Object[] args = new String[]{blkId, e.getMessage()};
            throw new XTSBlockProcessorException("blkprocessor.compileerror", args, e);
        }
        catch (Exception e) {
            Object[] args = new String[]{XSLT_CLASS_NAME};
            throw new XTSBlockProcessorException("transformer.instantiationerror", args, e);
        }
    }

    @Override
    public void process(XTSEnvironment env, Source source, Result result, boolean output, String blkId) throws XTSBlockProcessorException {
        block8: {
            if (this.m_oCachedTemplate == null) {
                Object[] args = new String[]{this.m_sIdentifier};
                throw new XTSBlockProcessorException("blkprocessor.uncompiled", args);
            }
            try {
                IXTSLogger logger;
                Transformer transformer = null;
                transformer = this.m_oCachedTemplate.newTransformer();
                if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                    logger.log(env, 8, "XSLT transformer class: " + transformer.getClass().getName(), null, null);
                }
                if (!output) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                }
                transformer.setURIResolver(this.m_oUriResolver);
                if (result instanceof StreamResult) {
                    transformer.transform(source, result);
                    break block8;
                }
                if (result instanceof SAXResult) {
                    transformer.transform(source, result);
                    break block8;
                }
                Object[] args = new Object[]{this.m_sIdentifier, result.getClass().getName()};
                throw new XTSBlockProcessorException("blkprocessor.unsupportedresulttype", args);
            }
            catch (TransformerConfigurationException e) {
                Object[] args = new String[]{blkId, e.getMessage()};
                throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
            }
            catch (TransformerException e) {
                Object[] args = new String[]{blkId, e.getMessage()};
                throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
            }
        }
    }

    @Override
    public void terminate() throws XTSBlockProcessorException {
        this.m_sIdentifier = null;
        this.m_oUriResolver = null;
        this.m_oCachedTemplate = null;
        this.m_sSource = null;
    }

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public String getSource() {
        return this.m_sSource;
    }
}

