/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.blockprocessor;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.blockprocessor.IXTSBlockProcessor;
import com.cognos.xts.blockprocessor.IXTSJavaBlock;
import com.cognos.xts.blockprocessor.XTSBlockProcessorException;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.dom4j.Element;

public final class JavaBlockProcessor
implements IXTSBlockProcessor {
    private static final String PARAM = "param";
    private static final String PARAM_ATT_NAME = "name";
    private static final String JAVA_CLASS = "class";
    private static final String JAVA_SOURCE = "source";
    private String m_sIdentifier = null;
    private Class m_class = null;
    private boolean m_cacheable = false;
    private IXTSJavaBlock m_obj = null;
    private String m_source = null;

    @Override
    public void initialize(String identifier) throws XTSBlockProcessorException {
        this.m_sIdentifier = identifier;
        this.m_class = null;
        this.m_cacheable = false;
        this.m_obj = null;
        this.m_source = null;
    }

    @Override
    public void compile(XTSEnvironment env, Element block, URIResolver uriResolver, String blkId) throws XTSBlockProcessorException {
        Object[] args;
        List paramList = block.elements(PARAM);
        if (paramList == null || paramList.size() == 0) {
            Object[] args2 = new String[]{blkId, PARAM};
            throw new XTSBlockProcessorException("blkprocessor.missingparam", args2);
        }
        String javaClass = null;
        String javaSource = null;
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            if (paramEle.attributeValue(PARAM_ATT_NAME).equals(JAVA_CLASS)) {
                javaClass = paramEle.getTextTrim();
                if (javaClass.length() != 0) continue;
                javaClass = null;
                continue;
            }
            if (!paramEle.attributeValue(PARAM_ATT_NAME).equals(JAVA_SOURCE) || (javaSource = paramEle.getTextTrim()).length() != 0) continue;
            javaSource = null;
        }
        if (javaClass != null && javaSource != null) {
            Object[] args3 = new String[]{blkId, JAVA_CLASS, JAVA_SOURCE};
            throw new XTSBlockProcessorException("blkprocessor.conflictparams", args3);
        }
        if (javaClass == null && javaSource == null) {
            Object[] args4 = new String[]{blkId, JAVA_CLASS};
            throw new XTSBlockProcessorException("blkprocessor.missingparam", args4);
        }
        if (javaSource != null) {
            this.m_source = javaSource;
        } else {
            try {
                this.m_class = Class.forName(javaClass);
            }
            catch (ClassNotFoundException e) {
                args = new String[]{blkId, e.getMessage()};
                throw new XTSBlockProcessorException("blkprocessor.compileerror", args, e);
            }
        }
        try {
            this.m_obj = (IXTSJavaBlock)this.m_class.newInstance();
            if (this.m_obj.isCacheable()) {
                this.m_cacheable = true;
                this.m_obj.initialize(blkId);
            } else {
                this.m_cacheable = false;
                this.m_obj = null;
            }
        }
        catch (Exception e) {
            args = new String[]{blkId, e.getMessage()};
            throw new XTSBlockProcessorException("blkprocessor.compileerror", args, e);
        }
    }

    @Override
    public void process(XTSEnvironment env, Source source, Result result, boolean output, String blkId) throws XTSBlockProcessorException {
        if (this.m_cacheable) {
            if (this.m_obj == null) {
                Object[] args = new String[]{blkId};
                throw new XTSBlockProcessorException("blkprocessor.uncompiled", args);
            }
        } else {
            try {
                this.m_obj = (IXTSJavaBlock)this.m_class.newInstance();
                this.m_obj.initialize(blkId);
            }
            catch (Exception e) {
                Object[] args = new String[]{blkId, e.getMessage()};
                throw new XTSBlockProcessorException("blkprocessor.compileerror", args, e);
            }
        }
        try {
            this.m_obj.execute(source, result);
        }
        catch (XTSBlockProcessorException e) {
            Object[] args = new String[]{blkId, e.getMessage()};
            throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
        }
        if (!this.m_cacheable) {
            this.m_obj.terminate();
            this.m_obj = null;
        }
    }

    @Override
    public void terminate() throws XTSBlockProcessorException {
        if (this.m_obj != null) {
            this.m_obj.terminate();
        }
        this.m_sIdentifier = null;
        this.m_class = null;
        this.m_cacheable = false;
        this.m_obj = null;
    }

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public String getSource() {
        return this.m_source;
    }
}

