/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.blockprocessor;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.blockprocessor.IXTSBlockProcessor;
import com.cognos.xts.blockprocessor.XTSBlockProcessorException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.util.SequenceReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLBlockProcessor
implements IXTSBlockProcessor {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private String m_sBlkXML = null;
    private String m_sIdentifier = null;

    @Override
    public void initialize(String identifier) throws XTSBlockProcessorException {
        this.m_sIdentifier = identifier;
        this.m_sBlkXML = null;
    }

    @Override
    public void compile(XTSEnvironment env, Element block, URIResolver uriResolver, String blkId) throws XTSBlockProcessorException {
        StringBuffer blockContent = new StringBuffer();
        List nodelist = block.content();
        Node node = null;
        for (int i = 0; i < nodelist.size(); ++i) {
            node = (Node)nodelist.get(i);
            if (node instanceof Namespace) continue;
            blockContent.append(node.asXML());
        }
        this.m_sBlkXML = blockContent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(XTSEnvironment env, Source source, Result result, boolean output, String blkId) throws XTSBlockProcessorException {
        block13: {
            if (result instanceof StreamResult) {
                try {
                    Closeable out = ((StreamResult)result).getOutputStream();
                    if (out != null) {
                        out.write(this.m_sBlkXML.getBytes("UTF-8"));
                    }
                    out = ((StreamResult)result).getWriter();
                    ((Writer)out).write(this.m_sBlkXML.toCharArray());
                }
                catch (IOException e) {
                    Object[] args = new String[]{blkId, e.getMessage()};
                    throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
                }
            } else {
                if (result instanceof SAXResult) {
                    try {
                        SequenceReader sr = new SequenceReader(new StringReader("<content>"), new SequenceReader(new StringReader(this.m_sBlkXML), new StringReader("</content>")));
                        AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
                        try {
                            XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                            reader.setContentHandler(((SAXResult)result).getHandler());
                            reader.setProperty(LEXICALHANDLER_PROPERTY, ((SAXResult)result).getHandler());
                            reader.parse(new InputSource(new BufferedReader(sr)));
                            break block13;
                        }
                        finally {
                            XTSSAXParserPool.getInstance().put(parser);
                        }
                    }
                    catch (SAXException e) {
                        Object[] args = new String[]{blkId, e.getMessage()};
                        throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
                    }
                    catch (IOException e) {
                        Object[] args = new String[]{blkId, e.getMessage()};
                        throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
                    }
                    catch (XTSException e) {
                        Object[] args = new String[]{blkId, e.getMessage()};
                        throw new XTSBlockProcessorException("blkprocessor.processerror", args, e);
                    }
                }
                Object[] args = new Object[]{this.m_sIdentifier, result.getClass().getName()};
                throw new XTSBlockProcessorException("blkprocessor.unsupportedresulttype", args);
            }
        }
    }

    @Override
    public void terminate() throws XTSBlockProcessorException {
        this.m_sIdentifier = null;
        this.m_sBlkXML = null;
    }

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public String getSource() {
        return this.m_sBlkXML;
    }
}

