/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.blockprocessor;

import com.cognos.xts.blockprocessor.IXTSBlockProcessor;
import com.cognos.xts.blockprocessor.XTSBlockProcessorException;
import com.cognos.xts.properties.PropertiesManager;

public class XTSBlockProcessorGenerator {
    public static IXTSBlockProcessor createProcessor(String processor) throws XTSBlockProcessorException {
        String prop = "blockprocessor.class." + processor;
        String blkProcessorClassName = PropertiesManager.getInstance().getProperty(prop);
        if (blkProcessorClassName == null) {
            Object[] args = new String[]{processor};
            throw new XTSBlockProcessorException("blkprocessor.unknownimplementation", args);
        }
        try {
            IXTSBlockProcessor blkprocessor = (IXTSBlockProcessor)Class.forName(blkProcessorClassName).newInstance();
            blkprocessor.initialize(processor);
            return blkprocessor;
        }
        catch (ClassNotFoundException e) {
            throw new XTSBlockProcessorException("blkprocessor.instantiationerror", e);
        }
        catch (IllegalAccessException e) {
            throw new XTSBlockProcessorException("blkprocessor.instantiationerror", e);
        }
        catch (InstantiationException e) {
            throw new XTSBlockProcessorException("blkprocessor.instantiationerror", e);
        }
    }
}

