/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.capability;

import com.cognos.xts.XTSException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class XTSCapabilityBusException
extends XTSException {
    private Element m_soapFault;
    private Element m_soapEnvelope;

    public XTSCapabilityBusException(String key, Element soapFault, Element soapEnvelope) {
        super(key);
        this.m_soapFault = soapFault;
        this.m_soapEnvelope = soapEnvelope;
    }

    @Override
    public Element getSoapEnvElementCopy(Locale locale, int soapVer) {
        if (this.m_soapEnvelope != null) {
            return this.m_soapEnvelope.createCopy();
        }
        return null;
    }

    public StringBuffer getSoapEnvStringBufferCopy() {
        Element envEle = this.getSoapEnvElementCopy(Locale.getDefault(), 11);
        if (envEle != null) {
            return new StringBuffer(envEle.asXML());
        }
        return null;
    }

    public Element getSoapHeaderElementCopy() {
        Element header = this.m_soapEnvelope.element("Header");
        if (header != null) {
            return header.createCopy();
        }
        return null;
    }

    public Reader getSoapHeaderReader() {
        StringReader hdrReader = null;
        Element header = this.m_soapEnvelope.element("Header");
        if (header != null) {
            try {
                hdrReader = new StringReader(header.asXML());
            }
            catch (Exception e) {
                return null;
            }
        }
        return hdrReader;
    }

    @Override
    public Element getFaultXML(Locale locale, boolean stackdump) {
        String sFaultString;
        String sFaultCode;
        Element exceptionElement = DocumentHelper.createElement((QName)EXCEPTION_QNAME);
        if (this.m_soapFault == null) {
            return exceptionElement;
        }
        Element excpetionCodeElement = DocumentHelper.createElement((QName)EXCEPTIONCODE_QNAME);
        Element soapFaultCodeEle = this.m_soapFault.element("faultcode");
        if (soapFaultCodeEle != null && (sFaultCode = soapFaultCodeEle.getText()) != null) {
            excpetionCodeElement.addText(sFaultCode);
        }
        exceptionElement.add(excpetionCodeElement);
        Element excpetionMsgElement = DocumentHelper.createElement((QName)EXCEPTIONMSG_QNAME);
        Element soapFaultStringEle = this.m_soapFault.element("faultstring");
        if (soapFaultStringEle != null && (sFaultString = soapFaultStringEle.getText()) != null) {
            excpetionMsgElement.addText(sFaultString);
        }
        exceptionElement.add(excpetionMsgElement);
        Element excpetionDetailElement = DocumentHelper.createElement((QName)EXCEPTIONDETAIL_QNAME);
        Element faultDetailEle = this.m_soapFault.element("detail");
        if (faultDetailEle != null) {
            excpetionDetailElement.appendContent((Branch)faultDetailEle);
        }
        exceptionElement.add(excpetionDetailElement);
        return exceptionElement;
    }
}

