/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.capability;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheFactory;
import com.cognos.xts.common.cache.AXTSCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import java.util.HashMap;
import java.util.Map;

public class XTSCapabilityFactory
extends AXTSCacheFactory {
    private static final String IDENTIFIER = "CapabilityFactory";
    private static final String PROPERTY_PREFIX = "capability.class.";
    private static final String CACHE_SIZE = "capabilitycache.size";
    public static final String ATTR_KEY1 = "name";
    public static final String DEFAULT_CLASS = "capability.defaultclass";
    private static XTSCapabilityFactory m_factory = new XTSCapabilityFactory();
    private HashMap m_oCapabilityMap = new HashMap();
    private int m_iCacheSize = 25;
    private String m_sDefaultClass = null;

    public static XTSCapabilityFactory getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() throws XTSCacheException {
        return this.m_iCacheSize;
    }

    @Override
    protected String getClassName(XTSEnvironment env, Map atts) throws XTSCacheException {
        String key = (String)atts.get(ATTR_KEY1);
        String classname = (String)this.m_oCapabilityMap.get(key);
        if (classname == null) {
            Object[] args = new String[]{key};
            throw new XTSCacheException("capabilityfactory.undefinedcapability", args);
        }
        return classname;
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map atts) throws XTSCacheException {
        return (String)atts.get(ATTR_KEY1);
    }

    @Override
    protected void preInitialize_Impl() throws XTSCacheException {
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE);
        if (sCacheSize != null) {
            try {
                this.m_iCacheSize = Integer.parseInt(sCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSCacheException("capabilityfactory.cacheinitfailed", e);
            }
        }
        this.m_sDefaultClass = PropertiesManager.getInstance().getProperty(DEFAULT_CLASS);
        HashMap propMap = PropertiesManager.getInstance().getPropertiesMap(PROPERTY_PREFIX);
        if (propMap.size() > 0) {
            String capClassName = null;
            String capName = null;
            Map.Entry pair2 = null;
            for (Map.Entry pair2 : propMap.entrySet()) {
                capClassName = (String)pair2.getValue();
                capName = ((String)pair2.getKey()).substring(PROPERTY_PREFIX.length());
                this.m_oCapabilityMap.put(capName, capClassName);
            }
        }
    }

    @Override
    protected void postInitialize_Impl() throws XTSCacheException {
    }

    @Override
    protected void preTerminate_Impl() throws XTSCacheException {
        this.m_oCapabilityMap.clear();
    }

    @Override
    protected void postTerminate_Impl() throws XTSCacheException {
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean isSupported(XTSEnvironment env, Map atts) throws XTSCacheException {
        String key = (String)atts.get(ATTR_KEY1);
        return this.m_oCapabilityMap.containsKey(key);
    }

    public AXTSCacheObject getDefaultObject(XTSEnvironment env) throws XTSCacheException {
        if (this.m_sDefaultClass == null) {
            return null;
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(ATTR_KEY1, this.m_sDefaultClass);
        return this.getObject(env, attr);
    }
}

