/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.cmdline;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarUtils {
    private static final boolean DEBUG = false;
    private static final String m_manifest = "Manifest-version: 1.0\r\nSealed: false\r\nCreated-By: XTSCompiler2\r\n\r\n";

    private static void addDirectoryFile(File dir, ArrayList ret) throws IOException {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                JarUtils.addDirectoryFile(list[i], ret);
                continue;
            }
            ret.add(list[i]);
        }
    }

    private static ArrayList getFileList(String basedir, String includes) throws IOException {
        ArrayList<File> ret = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(includes, ",");
        while (st.hasMoreTokens()) {
            String include = st.nextToken();
            File file = new File(basedir, include);
            if (!file.exists()) {
                throw new IOException("File not existed: " + file.getCanonicalPath());
            }
            if (file.isDirectory()) {
                JarUtils.addDirectoryFile(file, ret);
                continue;
            }
            ret.add(file);
        }
        return ret;
    }

    private static void addDirectory(String idxbase, File dir, ArrayList ret) throws IOException {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isDirectory()) continue;
            String childPath = list[i].getCanonicalPath();
            String entryPath = childPath.substring(idxbase.length());
            if (entryPath.charAt(0) == File.separatorChar) {
                ret.add(entryPath.substring(1));
            } else {
                ret.add(entryPath);
            }
            JarUtils.addDirectory(idxbase, list[i], ret);
        }
    }

    private static ArrayList getDirectoryList(String basedir, String idxbase) throws IOException {
        ArrayList ret = new ArrayList();
        File idxbaseFile = new File(basedir, idxbase);
        String idxbasePath = idxbaseFile.getCanonicalPath();
        if (idxbaseFile.isDirectory()) {
            JarUtils.addDirectory(idxbasePath, idxbaseFile, ret);
        }
        return ret;
    }

    private static File createDirectoryList(String base, String idxbase, String idxfile) throws IOException {
        File idxFile = new File(base, idxfile);
        ArrayList dirs = JarUtils.getDirectoryList(base, idxbase);
        PrintStream out = new PrintStream(new FileOutputStream(idxFile));
        for (int i = 0; i < dirs.size(); ++i) {
            String entry = (String)dirs.get(i);
            out.write(entry.getBytes("UTF-8"));
            out.println();
        }
        out.flush();
        out.close();
        return idxFile;
    }

    private static Manifest createManifest(String manifestfile) throws IOException {
        if (manifestfile == null) {
            return new Manifest(new ByteArrayInputStream(m_manifest.getBytes("UTF-8")));
        }
        File mFile = new File(manifestfile);
        if (!mFile.exists()) {
            throw new IOException("Manifest file not existed (" + manifestfile + ")");
        }
        FileInputStream fin = new FileInputStream(mFile);
        Manifest manifest = new Manifest(fin);
        fin.close();
        return manifest;
    }

    public static void execute(String dest, String basedir, String includes, String manifestfile, String idxdir, String idxfile) throws IOException {
        File basefile = new File(basedir);
        ArrayList filelist = JarUtils.getFileList(basedir, includes);
        File indexFile = JarUtils.createDirectoryList(basedir, idxdir, idxfile);
        filelist.add(indexFile);
        Manifest manifest = JarUtils.createManifest(manifestfile);
        File out = new File(dest);
        if (out.exists()) {
            if (out.isDirectory()) {
                throw new IOException("output is a directory (" + dest + ")");
            }
            out.delete();
        } else {
            File outparent = out.getParentFile();
            if (!outparent.exists()) {
                outparent.mkdirs();
            }
        }
        FileOutputStream fout = new FileOutputStream(out);
        JarOutputStream jout = new JarOutputStream((OutputStream)fout, manifest);
        byte[] buf = new byte[4096];
        int readsize = -1;
        for (int j = 0; j < filelist.size(); ++j) {
            File file = (File)filelist.get(j);
            String jname = file.getCanonicalPath();
            String bname = basefile.getCanonicalPath();
            if (jname.length() <= bname.length()) {
                throw new IOException("Target name is shorter than base name?");
            }
            jname = jname.substring(bname.length() + 1).replace('\\', '/');
            jout.putNextEntry(new JarEntry(jname));
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            while ((readsize = fis.read(buf)) != -1) {
                jout.write(buf, 0, readsize);
            }
            fis.close();
            jout.flush();
            jout.closeEntry();
        }
        jout.flush();
        jout.close();
    }
}

