/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.cmdline;

import com.cognos.xts.XTSException;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.IXTSResourceReader;
import com.cognos.xts.resource.PathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;

public class XTSCmdLineResourceReader
implements IXTSResourceReader {
    private DirEnt m_root = null;

    @Override
    public InputStream getResourceFromClassLoader(String name) throws XTSException {
        InputStream is = null;
        try {
            String sFile = PathUtils.buildPath("com/cognos/xts", name);
            is = this.getClass().getClassLoader().getResourceAsStream(sFile);
            if (is != null) {
                return is;
            }
        }
        catch (IOException e) {
            is = null;
        }
        return is;
    }

    @Override
    public InputStream getResourceFromTemplates(String name) throws XTSException {
        FileInputStream is = null;
        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
        try {
            if (!PathUtils.isChild(templateRoot, name)) {
                Object[] args = new String[]{name};
                throw new XTSException("reader.securityviolation", args);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{name};
            throw new XTSException("reader.securityviolation", args);
        }
        try {
            String sFile = PathUtils.buildPath(templateRoot, name);
            is = new FileInputStream(sFile);
        }
        catch (IOException e) {
            is = null;
        }
        return is;
    }

    @Override
    public InputStream getResource(String name) throws XTSException {
        InputStream is = null;
        try {
            String sFile = PathUtils.buildPath("com/cognos/xts", name);
            is = this.getClass().getClassLoader().getResourceAsStream(sFile);
            if (is != null) {
                return is;
            }
        }
        catch (IOException e) {
            is = null;
        }
        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
        try {
            if (!PathUtils.isChild(templateRoot, name)) {
                Object[] args = new String[]{name};
                throw new XTSException("reader.securityviolation", args);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{name};
            throw new XTSException("reader.securityviolation", args);
        }
        try {
            String sFile = PathUtils.buildPath(templateRoot, name);
            is = new FileInputStream(sFile);
        }
        catch (IOException e) {
            is = null;
        }
        return is;
    }

    @Override
    public DirEnt getTemplateRoot() throws XTSException {
        if (this.m_root != null) {
            return this.m_root;
        }
        this.m_root = new DirEnt(".");
        this.getJARDirectories(this.m_root);
        this.getFSDirectories(this.m_root);
        return this.m_root;
    }

    private void getJARDirectories(DirEnt root) {
        Enumeration<URL> idxlist = null;
        try {
            idxlist = this.getClass().getClassLoader().getResources("com/cognos/xts/xts.lst");
        }
        catch (IOException e) {
            return;
        }
        while (idxlist.hasMoreElements()) {
            try {
                URL idxFile = idxlist.nextElement();
                InputStream is = idxFile.openStream();
                if (is == null) continue;
                this.addChildDirectories(root, is);
            }
            catch (IOException iOException) {}
        }
    }

    private void addChildDirectories(DirEnt root, InputStream is) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            root.addChild(line);
        }
    }

    private void getFSDirectories(DirEnt root) {
        String basePath = PropertiesManager.getInstance().getProperty("template.root");
        File baseFile = new File(basePath);
        if (!baseFile.isDirectory()) {
            return;
        }
        this.addFSEnt(baseFile, root);
    }

    private void addFSEnt(File baseFile, DirEnt ent) {
        File[] childrenFiles = baseFile.listFiles();
        if (childrenFiles == null) {
            return;
        }
        for (int i = 0; i < childrenFiles.length; ++i) {
            File childFile = childrenFiles[i];
            if (!childFile.isDirectory()) continue;
            try {
                DirEnt childEnt = ent.addChild(childFile.getName());
                this.addFSEnt(childFile, childEnt);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

