/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.cmdline;

import com.cognos.xts.XTSBlock;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSObject;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.cmdline.JarUtils;
import com.cognos.xts.cmdline.XTSCmdLineResourceReader;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.util.StopWatchTimer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;

public final class XTSCompiler2 {
    private static final String CALLER_ID = "XTSCompiler";
    private String m_input = null;
    private Properties m_globalProp = new Properties();
    private Document m_doc = null;
    private static final int BUFSIZE = 8192;

    private void usage() {
        System.out.println("Usage: com.cognos.xts.util.XTSCompiler2");
        System.out.println("");
        System.out.println("Required parameters:");
        System.out.println("");
        System.out.println("   -xml <inputfile>");
        System.out.println("       The xml input file that holds the compile specification. ");
        System.out.println("       The xml input file will looks like:");
        System.out.println("       <xtscompiler>");
        System.out.println("         <xtsParam>");
        System.out.println("           <param name=\"template.root\">../templates/ps</param>");
        System.out.println("         </xtsParam>");
        System.out.println("         <workingDirectory>%workdir%</workingDirectory>");
        System.out.println("         <includeTestBlock>false</includeTestBlock>");
        System.out.println("         <debugMode>false</debugMode>");
        System.out.println("         <printStatus>true</printStatus>");
        System.out.println("         <loop clang=\"%lang%\">");
        System.out.println("           <compile>");
        System.out.println("             <source>");
        System.out.println("               <file>portal.xts</file>");
        System.out.println("               <directory>portal</directory>");
        System.out.println("             </source>");
        System.out.println("             <lang>%clang%</lang>");
        System.out.println("           </compile>");
        System.out.println("           <jar dest=\"%outdir%/portal_%clang%.jar\"");
        System.out.println("                base=\"%workdir%\"");
        System.out.println("                lang=\"%clang%\"");
        System.out.println("                includes=\"portal\"");
        System.out.println("                manifest=\"%manifestdir%/portaljar-manifest\"/>");
        System.out.println("         </loop>");
        System.out.println("       </xtscompiler>");
        System.out.println("");
        System.out.println("   where: ");
        System.out.println("");
        System.out.println("     xtsParam             - properties that overrides xts engine default properties. ");
        System.out.println("     nestedMessage        - number of levels of message to returned. ");
        System.out.println("     workingDirectory     - directory to store the compiled object. ");
        System.out.println("     includeTestBlock     - indicated whether test block should be included in the ");
        System.out.println("                            compiled result. ");
        System.out.println("     debugMode            - indicated whether the compile process should be run in ");
        System.out.println("                            debug mode, and hence generate debug information in the ");
        System.out.println("                            \"option.debugdir\" directory specified in the xts.properties. ");
        System.out.println("     printStatus          - indicated whether status should be printed for each compilation. ");
        System.out.println("     loop                 - a list comma-separated list of values to be assigned to ");
        System.out.println("                            the loop-control-variables (which is the clang in this example). ");
        System.out.println("     file/directory       - indicated the compile source. ");
        System.out.println("                            = exclude option is only used with directory, which is a ");
        System.out.println("                              comma separate list of directory/file names to be excluded. ");
        System.out.println("     lang                 - indicated which language should be used for compilation. ");
        System.out.println("     compile              - compile the specified objects. ");
        System.out.println("     jar                  - create a jar file based on the specified parameters. ");
        System.out.println("              dest        - target jar file name and path. ");
        System.out.println("              base        - base directory of the created jar file. ");
        System.out.println("              lang        - language used to create the jar file. ");
        System.out.println("              includes    - comma separated list of directory. ");
        System.out.println("              mainfest    - Optional, user defined manifest file. ");
        System.out.println("");
        System.out.println("Optional parameters:");
        System.out.println("");
        System.out.println("   -P<name>=<value>");
        System.out.println("       Name of property that used to substitute %name% macro in the run specification.");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("   XTSCompiler2 -xml my.xml -Plang=en,fr,de,ja -Pxxx=yyy");
    }

    private boolean parseArg(String[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("-xml")) {
                if (++i > args.length) {
                    return false;
                }
                this.m_input = args[i].trim();
                if (this.m_input.length() != 0) continue;
                return false;
            }
            if (arg.startsWith("-P")) {
                int index = arg.indexOf("=");
                if (index == -1) {
                    return false;
                }
                String key = "%" + arg.substring(2, index) + "%";
                String value = arg.substring(index + 1, arg.length());
                this.m_globalProp.setProperty(key, value);
                continue;
            }
            System.out.println("Unknown parameter: " + arg);
            return false;
        }
        return true;
    }

    private String applyMacro(String value, Properties curProp) {
        int idx = -1;
        String ret = value;
        Enumeration<?> keylist = curProp.propertyNames();
        while (keylist.hasMoreElements()) {
            String key = (String)keylist.nextElement();
            String keyvalue = curProp.getProperty(key);
            idx = ret.indexOf(key);
            while (idx != -1) {
                ret = ret.substring(0, idx) + keyvalue + ret.substring(idx + key.length(), ret.length());
                idx = ret.indexOf(key);
            }
        }
        return ret;
    }

    private void resolveMacro(Element ele, Properties curProp) {
        String newText = this.applyMacro(ele.getTextTrim(), curProp);
        ArrayList<Node> rlist = new ArrayList<Node>();
        int size = ele.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = ele.node(i);
            if (!(node instanceof Text)) continue;
            rlist.add(node);
        }
        for (int j = 0; j < rlist.size(); ++j) {
            ele.remove((Text)rlist.get(j));
        }
        if (newText.length() > 0) {
            ele.addText(newText);
        }
        List list = ele.elements();
        for (int i = 0; i < list.size(); ++i) {
            this.resolveMacro((Element)list.get(i), curProp);
        }
    }

    private Document readInputFile() {
        try {
            File file = new File(this.m_input);
            SAXReader reader = new SAXReader();
            return reader.read(file);
        }
        catch (Exception e) {
            System.out.println("Exception caught when reading input file: " + e.getMessage());
            return null;
        }
    }

    private Properties createOverrideProperties(Document doc, Properties curProp) {
        Properties xtsProp = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("xts.properties");
        if (is != null) {
            try {
                xtsProp.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties prop = new Properties(xtsProp);
        Element engineParam = doc.getRootElement().element("xtsParam");
        if (engineParam != null) {
            List list = engineParam.elements("param");
            for (int i = 0; i < list.size(); ++i) {
                String value;
                Element param = (Element)list.get(i);
                String name = param.attributeValue("name");
                if (name == null || (value = param.getTextTrim()) == null) continue;
                value = this.applyMacro(value, curProp);
                prop.setProperty(name, value);
            }
        }
        return prop;
    }

    private Document createInputDoc(Element run) {
        Element root = DocumentHelper.createElement((String)"root");
        Document doc = DocumentHelper.createDocument((Element)root);
        root.addElement("output");
        return doc;
    }

    private void processLoop(Element loop, Properties curProp, String workingDir, boolean includeTestBlk, boolean debugMode, boolean printStatus) throws XTSException, Exception {
        Attribute ctrlVar = loop.attribute(0);
        String name = "%" + ctrlVar.getName() + "%";
        String valuelist = ctrlVar.getValue();
        if (valuelist == null || valuelist.length() == 0) {
            throw new Exception("Empty control value encountered.");
        }
        valuelist = this.applyMacro(ctrlVar.getValue(), curProp);
        StringTokenizer st = new StringTokenizer(valuelist, ",");
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            Properties newProp = new Properties(curProp);
            newProp.setProperty(name, value);
            List elelist = loop.elements();
            for (int i = 0; i < elelist.size(); ++i) {
                Element ele = (Element)elelist.get(i);
                if (ele.getName().equals("loop")) {
                    Element loopele = ele.createCopy();
                    this.processLoop(loopele, newProp, workingDir, includeTestBlk, debugMode, printStatus);
                    continue;
                }
                if (ele.getName().equals("compile")) {
                    Element compileele = ele.createCopy();
                    this.processCompile(compileele, newProp, workingDir, includeTestBlk, debugMode, printStatus);
                    continue;
                }
                if (!ele.getName().equals("jar")) continue;
                Element jarele = ele.createCopy();
                this.processJar(jarele, newProp, workingDir, printStatus);
            }
        }
    }

    private void processCompile(Element compile, Properties curProp, String workingDir, boolean includeTestBlk, boolean debugMode, boolean printStatus) throws XTSException, Exception {
        this.resolveMacro(compile, curProp);
        Element sourceele = compile.element("source");
        if (sourceele == null) {
            throw new Exception("Missing source parameter.");
        }
        List filelist = sourceele.elements("file");
        for (int j = 0; j < filelist.size(); ++j) {
            Document inputdoc = this.createInputDoc(compile);
            this.processFile(inputdoc, ((Element)filelist.get(j)).getTextTrim(), workingDir, includeTestBlk, debugMode, printStatus);
        }
        List dirlist = sourceele.elements("directory");
        for (int k = 0; k < dirlist.size(); ++k) {
            Document inputdoc = this.createInputDoc(compile);
            String dirname = ((Element)dirlist.get(k)).getTextTrim();
            HashSet excludeSet = this.createExcludeSet(((Element)dirlist.get(k)).attributeValue("exclude"));
            this.processDirectory(inputdoc, dirname, excludeSet, workingDir, includeTestBlk, debugMode, printStatus);
        }
    }

    private HashSet createExcludeSet(String list) {
        HashSet<String> ret = new HashSet<String>();
        if (list != null && list.length() > 0) {
            StringTokenizer st = new StringTokenizer(list, ",");
            while (st.hasMoreTokens()) {
                String value = st.nextToken().trim();
                ret.add(value);
            }
        }
        return ret;
    }

    private void processJar(Element jar, Properties curProp, String workingDir, boolean printStatus) throws XTSException, Exception {
        String dest = jar.attributeValue("dest");
        if (dest == null || dest.length() == 0) {
            throw new Exception("Empty dest value encountered.");
        }
        dest = this.applyMacro(dest, curProp);
        String base = jar.attributeValue("base");
        if (base == null || base.length() == 0) {
            throw new Exception("Empty base value encountered.");
        }
        base = this.applyMacro(base, curProp);
        String includes = jar.attributeValue("includes");
        if (includes == null || includes.length() == 0) {
            throw new Exception("Empty includes value encountered.");
        }
        includes = this.applyMacro(includes, curProp);
        String manifest = jar.attributeValue("manifest");
        manifest = manifest == null || manifest.length() == 0 ? null : this.applyMacro(manifest, curProp);
        StringBuilder filelistBuilder = new StringBuilder("");
        StringTokenizer st = new StringTokenizer(includes, ",");
        while (st.hasMoreTokens()) {
            filelistBuilder.append(PathUtils.buildPath("com/cognos/xts", st.nextToken()));
            if (!st.hasMoreTokens()) continue;
            filelistBuilder.append(",");
        }
        String idxDir = "com/cognos/xts";
        String idxFile = "com/cognos/xts/xts.lst";
        String filelist = filelistBuilder.toString();
        if (printStatus) {
            System.out.println("Creating JAR files: " + dest);
            System.out.println("    base directory: " + base);
            System.out.println("    includes files: " + filelist);
        }
        JarUtils.execute(dest, base, filelist, manifest, idxDir, idxFile);
        if (printStatus) {
            System.out.println("Creating JAR files: Done");
        }
    }

    public void run(String[] args) throws Exception {
        if (!this.parseArg(args)) {
            this.usage();
            return;
        }
        Document doc = this.readInputFile();
        if (doc == null) {
            return;
        }
        int msglevel = 5;
        try {
            Element nestedMessage = doc.getRootElement().element("nestedMessage");
            if (nestedMessage != null) {
                String level = nestedMessage.getTextTrim();
                if (level != null && level.length() > 0) {
                    level = this.applyMacro(level, this.m_globalProp);
                }
                msglevel = Integer.parseInt(level);
            }
            String workingDirectory = null;
            Element workdir = doc.getRootElement().element("workingDirectory");
            if (workdir != null) {
                workingDirectory = workdir.getTextTrim();
                if (workingDirectory == null || workingDirectory.length() == 0) {
                    System.out.println("Empty workingDirectory parameter encountered.");
                }
                workingDirectory = this.applyMacro(workingDirectory, this.m_globalProp);
            }
            boolean includeTestBlock = false;
            Element testBlk = doc.getRootElement().element("includeTestBlock");
            if (testBlk != null) {
                String sTestBlk = testBlk.getTextTrim();
                if (sTestBlk == null || sTestBlk.length() == 0) {
                    System.out.println("Empty includeTestBlock parameter encountered.");
                }
                sTestBlk = this.applyMacro(sTestBlk, this.m_globalProp);
                includeTestBlock = sTestBlk.equals("true");
            }
            boolean debugMode = false;
            Element debug = doc.getRootElement().element("debugMode");
            if (debug != null) {
                String sDebug = debug.getTextTrim();
                if (sDebug == null || sDebug.length() == 0) {
                    System.out.println("Empty debugMode parameter encountered.");
                }
                sDebug = this.applyMacro(sDebug, this.m_globalProp);
                debugMode = sDebug.equals("true");
            }
            boolean printStatus = false;
            Element status = doc.getRootElement().element("printStatus");
            if (status != null) {
                String sStatus = status.getTextTrim();
                if (sStatus == null || sStatus.length() == 0) {
                    System.out.println("Empty status parameter encountered.");
                }
                sStatus = this.applyMacro(sStatus, this.m_globalProp);
                printStatus = sStatus.equals("true");
            }
            Properties prop = this.createOverrideProperties(doc, this.m_globalProp);
            XTSProcessor.getInstance(CALLER_ID).initialize(null, new XTSCmdLineResourceReader(), null, prop, true);
            List list = doc.getRootElement().elements();
            for (int i = 0; i < list.size(); ++i) {
                Element ele = (Element)list.get(i);
                if (ele.getName().equals("loop")) {
                    Element loopele = ele.createCopy();
                    this.processLoop(loopele, this.m_globalProp, workingDirectory, includeTestBlock, debugMode, printStatus);
                    continue;
                }
                if (ele.getName().equals("compile")) {
                    Element compileele = ele.createCopy();
                    this.processCompile(compileele, this.m_globalProp, workingDirectory, includeTestBlock, debugMode, printStatus);
                    continue;
                }
                if (!ele.getName().equals("jar")) continue;
                Element jarele = ele.createCopy();
                this.processJar(jarele, this.m_globalProp, workingDirectory, printStatus);
            }
            XTSProcessor.getInstance(CALLER_ID).terminate(true);
        }
        catch (XTSException e) {
            System.out.println("XTS exception encountered.");
            System.out.println("Root cause: ");
            System.out.println(e.getLastLocalizedMsgString(new Locale("en", ""), msglevel));
            throw e;
        }
        catch (Exception e) {
            System.out.println("Execution interrupted.");
            System.out.println("Root cause: ");
            System.out.println(e.getMessage());
            throw e;
        }
    }

    private void processDirectory(Document doc, String dir, HashSet excludeSet, String workingDir, boolean includeTestBlk, boolean debugMode, boolean printStatus) throws XTSException, Exception {
        File rootFile = new File(PropertiesManager.getInstance().getProperty("template.root"));
        String rootPath = rootFile.getCanonicalPath();
        File indir = new File(rootFile, dir);
        if (!indir.exists()) {
            throw new Exception("Directory (" + indir.getCanonicalPath() + ") doesn't existed.");
        }
        if (!indir.isDirectory()) {
            throw new Exception("Directory (" + indir.getCanonicalPath() + ") isn't a directory.");
        }
        if (printStatus) {
            System.out.println("Compiling directory: " + indir.getCanonicalPath());
        }
        File[] list = indir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            String rpath = list[i].getCanonicalPath().substring(rootPath.length());
            if (list[i].isDirectory()) {
                if (!excludeSet.contains(list[i].getName())) {
                    this.processDirectory(doc, rpath, excludeSet, workingDir, includeTestBlk, debugMode, printStatus);
                    continue;
                }
                System.out.println("  Ignore directory: " + list[i].getName());
                continue;
            }
            if (!list[i].getName().endsWith(".xts")) continue;
            if (!excludeSet.contains(list[i].getName())) {
                this.processFile(doc, rpath, workingDir, includeTestBlk, debugMode, printStatus);
                continue;
            }
            System.out.println("  Ignore file: " + list[i].getName());
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(Document doc, String file, String workingDir, boolean includeTestBlk, boolean debugMode, boolean printStatus) throws XTSException, Exception {
        if (file == null || file.length() == 0) {
            throw new Exception("Empty parameter - 'file'");
        }
        String sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
        if (printStatus) {
            File iFile = new File(sTemplateRoot, file);
            System.out.println("  Compiling template: ");
            System.out.println("    source : " + iFile.getAbsolutePath());
        }
        XTSEnvironment env = new XTSEnvironment(CALLER_ID);
        try {
            env.setLocale(Locale.getDefault());
            env.setLookupList(null);
            env.setMorphletName(file);
            String debugRequestPath = null;
            if (debugMode) {
                env.setMode(2);
                String debugBasedir = null;
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debugBasedir = debuglogger.getBaseDirPath();
                }
                if (debugBasedir != null) {
                    StringBuffer debugRequestPathBuf = new StringBuffer(debugBasedir);
                    debugRequestPathBuf.append(File.separatorChar).append(file);
                    debugRequestPathBuf.append(File.separatorChar).append("compilation-");
                    debugRequestPathBuf.append(System.currentTimeMillis());
                    debugRequestPath = debugRequestPathBuf.toString();
                    env.setDebugRequestPath(new File(debugRequestPath).getCanonicalPath());
                }
            }
            StopWatchTimer timer = new StopWatchTimer();
            timer.start();
            XTSObject oObj = new XTSObject(env, file, true);
            if (oObj == null) {
                throw new Exception("Object doesn't exist");
            }
            StopWatchTimer childtimer = timer.createChild();
            oObj.compile(env, debugRequestPath, childtimer);
            timer.stop();
            this.doOutput(oObj, file, workingDir, includeTestBlk, printStatus);
            if (printStatus) {
                System.out.println("    execute status: success.");
                System.out.println("    compile time: " + Long.toString(timer.getElapseTime()) + "ms.");
            }
        }
        finally {
            env.cleanup();
        }
    }

    private void doOutput(XTSObject oObj, String file, String workingDir, boolean includeTestBlk, boolean printStatus) throws Exception {
        File parent;
        String sFile = PathUtils.buildPath("com/cognos/xts", file);
        File outfile = new File(workingDir, sFile);
        if (outfile.isDirectory()) {
            throw new Exception("Parameter 'out' is a directory");
        }
        if (outfile.exists()) {
            outfile.delete();
        }
        if (!(parent = outfile.getParentFile()).exists()) {
            parent.mkdirs();
        }
        Document doc = DocumentHelper.parseText((String)oObj.toString());
        this.strip(doc, includeTestBlk);
        FileOutputStream fos = new FileOutputStream(outfile);
        if (fos == null) {
            throw new Exception("Cannot create target file: " + outfile.getCanonicalPath());
        }
        fos.write(doc.asXML().getBytes("UTF-8"));
        fos.flush();
        fos.close();
        if (printStatus) {
            System.out.println("    output : " + outfile.getAbsolutePath());
        }
    }

    private void strip(Document doc, boolean includeTestBlk) throws Exception {
        Element morphletElem = doc.getRootElement();
        List blockList = morphletElem.elements(XTSBlock.XTS_BLOCK_QNAME);
        Element blkElem = null;
        String blkType = null;
        Attribute pathAtt = null;
        for (int i = 0; i < blockList.size(); ++i) {
            blkElem = (Element)blockList.get(i);
            blkType = blkElem.attributeValue("type");
            if (!includeTestBlk && blkType.equals("test")) {
                blkElem.detach();
                continue;
            }
            pathAtt = blkElem.attribute("path");
            if (pathAtt == null) continue;
            pathAtt.detach();
        }
    }

    public static void main(String[] args) {
        XTSCompiler2 runner = new XTSCompiler2();
        try {
            runner.run(args);
            System.gc();
            System.runFinalization();
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }
}

