/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.cmdline;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.cmdline.XTSCmdLineResourceReader;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.util.LocaleUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;

public final class XTSRunner2 {
    private static final String CALLER_ID = "XTSRunner";
    private String m_input = null;
    private Properties m_globalProp = new Properties();
    private Document m_doc = null;
    private static final int BUFSIZE = 8192;

    private void usage() {
        System.out.println("Usage: com.cognos.xts.util.XTSRunner");
        System.out.println("");
        System.out.println("Required parameters:");
        System.out.println("");
        System.out.println("   -xml = <inputfile>");
        System.out.println("       The xml input file that holds the run specification. ");
        System.out.println("       The xml input file will looks like:");
        System.out.println("           <xtsrunner> ");
        System.out.println("             <xtsParam> ");
        System.out.println("               <param name=\"template.root\">E:/crn/cer2/templates/ps</param> ");
        System.out.println("             </xtsParam> ");
        System.out.println("             <nestedMessage>5</nestedMessage> ");
        System.out.println("             <printStatus>true</printStatus> ");
        System.out.println("             <loop xxx=\"aaa\"> ");
        System.out.println("              <run> ");
        System.out.println("               <source> ");
        System.out.println("                 <file> ");
        System.out.println("                   <in>/x/y/a.xts</in> ");
        System.out.println("                   <out>E:/a/b/crq_%lang%_ie6/c.xts%ext%</out> ");
        System.out.println("                 </file> ");
        System.out.println("                 ... ");
        System.out.println("               </source> ");
        System.out.println("               <lang>%lang%</lang> ");
        System.out.println("               <envParam> ");
        System.out.println("                 <param name=\"productLocale\">%lang%</param> ");
        System.out.println("               </envParam> ");
        System.out.println("               <httpParam> ");
        System.out.println("                 <param name=\"xyz\">%xxx%</param> ");
        System.out.println("               </httpParam> ");
        System.out.println("               <systemParam> ");
        System.out.println("                 <param name=\"abc\">yyy</param> ");
        System.out.println("               </systemParam> ");
        System.out.println("               <outputProtocolEntityHeader>false</outputProtocolEntityHeader> ");
        System.out.println("              </run> ");
        System.out.println("             </loop> ");
        System.out.println("             <run> ");
        System.out.println("               ... ");
        System.out.println("             </run> ");
        System.out.println("           </xtsrunner> ");
        System.out.println("Optional parameters:");
        System.out.println("");
        System.out.println("   -P<name>=<value>");
        System.out.println("       Name of property that used to substitute %name% macro in the run specification.");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("   XTSRunner -xml my.xml -Plang=en -Pext=.htm -Pxxx=yyy");
    }

    private boolean parseArg(String[] args) {
        if (args == null || args.length < 1) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("-xml")) {
                if (++i > args.length) {
                    return false;
                }
                this.m_input = args[i].trim();
                if (this.m_input.length() != 0) continue;
                return false;
            }
            if (arg.startsWith("-P")) {
                int index = arg.indexOf("=");
                if (index == -1) {
                    return false;
                }
                String key = "%" + arg.substring(2, index) + "%";
                String value = arg.substring(index + 1, arg.length());
                this.m_globalProp.setProperty(key, value);
                continue;
            }
            System.out.println("Unknown parameter: " + arg);
            return false;
        }
        return true;
    }

    private String applyMacro(String value, Properties curProp) {
        int idx = -1;
        String ret = value;
        Enumeration<?> keylist = curProp.propertyNames();
        while (keylist.hasMoreElements()) {
            String key = (String)keylist.nextElement();
            String keyvalue = curProp.getProperty(key);
            idx = ret.indexOf(key);
            while (idx != -1) {
                ret = ret.substring(0, idx) + keyvalue + ret.substring(idx + key.length(), ret.length());
                idx = ret.indexOf(key);
            }
        }
        return ret;
    }

    private void resolveMacro(Element ele, Properties curProp) {
        String newText = this.applyMacro(ele.getTextTrim(), curProp);
        ArrayList<Node> rlist = new ArrayList<Node>();
        int size = ele.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = ele.node(i);
            if (!(node instanceof Text)) continue;
            rlist.add(node);
        }
        for (int j = 0; j < rlist.size(); ++j) {
            ele.remove((Text)rlist.get(j));
        }
        if (newText.length() > 0) {
            ele.addText(newText);
        }
        List list = ele.elements();
        for (int i = 0; i < list.size(); ++i) {
            this.resolveMacro((Element)list.get(i), curProp);
        }
    }

    private Document readInputFile() {
        try {
            File file = new File(this.m_input);
            SAXReader reader = new SAXReader();
            return reader.read(file);
        }
        catch (Exception e) {
            System.out.println("Exception caught when reading input file: " + e.getMessage());
            return null;
        }
    }

    private Properties createOverrideProperties(Document doc, Properties curProp) {
        Properties xtsProp = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("xts.properties");
        if (is != null) {
            try {
                xtsProp.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties prop = new Properties(xtsProp);
        Element engineParam = doc.getRootElement().element("xtsParam");
        if (engineParam != null) {
            List list = engineParam.elements("param");
            for (int i = 0; i < list.size(); ++i) {
                String value;
                Element param = (Element)list.get(i);
                String name = param.attributeValue("name");
                if (name == null || (value = param.getTextTrim()) == null) continue;
                value = this.applyMacro(value, curProp);
                prop.setProperty(name, value);
            }
        }
        return prop;
    }

    private boolean existed(Element e, String name) {
        List eleList = e.elements();
        for (int i = 0; i < eleList.size(); ++i) {
            String paramName = ((Element)eleList.get(i)).attributeValue("name");
            if (paramName == null || !paramName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private Element mergeParamElement(Element source, Element overrides) {
        if (source == null) {
            return overrides.createCopy("system");
        }
        if (overrides == null) {
            return source.createCopy("system");
        }
        Element result = overrides.createCopy("system");
        List eleList = source.elements();
        for (int i = 0; i < eleList.size(); ++i) {
            Element paramElement = (Element)eleList.get(i);
            String paramName = paramElement.attributeValue("name");
            if (paramName == null || this.existed(result, paramName)) continue;
            result.add(paramElement.createCopy());
        }
        return result;
    }

    private Document createInputDoc(Element envParam, Element httpParam, Element systemParam, String file) {
        Element root = DocumentHelper.createElement((String)"root");
        Document doc = DocumentHelper.createDocument((Element)root);
        root.addElement("output");
        if (envParam != null) {
            Element env = envParam.createCopy("env");
            root.add(env);
        }
        if (httpParam != null) {
            Element http = httpParam.createCopy("http");
            root.add(http);
        }
        Element systemElement = null;
        try {
            String morphlet = PathUtils.buildPath(file);
            systemElement = XTSApplicationManager.getInstance().getSystemOptions(morphlet);
        }
        catch (IOException e) {
            systemElement = null;
        }
        if (systemElement == null) {
            systemElement = XTSApplicationManager.getInstance().getDefaultSystemOptions();
        }
        if ((systemElement = this.mergeParamElement(systemElement, systemParam)) != null) {
            root.add(systemElement);
        }
        return doc;
    }

    private void processLoop(Element loop, boolean status, Properties curProp) throws XTSException, Exception {
        Attribute ctrlVar = loop.attribute(0);
        String name = "%" + ctrlVar.getName() + "%";
        String valuelist = ctrlVar.getValue();
        if (valuelist == null || valuelist.length() == 0) {
            throw new Exception("Empty control value encountered.");
        }
        valuelist = this.applyMacro(ctrlVar.getValue(), curProp);
        StringTokenizer st = new StringTokenizer(valuelist, ",");
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            Properties newProp = new Properties(curProp);
            newProp.setProperty(name, value);
            List elelist = loop.elements();
            for (int i = 0; i < elelist.size(); ++i) {
                Element ele = (Element)elelist.get(i);
                if (ele.getName().equals("loop")) {
                    Element loopele = ele.createCopy();
                    this.processLoop(loopele, status, newProp);
                    continue;
                }
                if (!ele.getName().equals("run")) continue;
                Element runele = ele.createCopy();
                this.processRun(runele, status, newProp);
            }
        }
    }

    private void processRun(Element run, boolean status, Properties curProp) throws XTSException, Exception {
        this.resolveMacro(run, curProp);
        Element langele = run.element("lang");
        if (langele == null) {
            throw new Exception("Missing lang parameter.");
        }
        String lang = langele.getTextTrim();
        Element headerele = run.element("outputProtocolEntityHeader");
        if (headerele == null) {
            throw new Exception("Missing outputProtocolEntityHeader parameter.");
        }
        boolean header = headerele.getTextTrim().equals("true");
        Element sourceele = run.element("source");
        if (sourceele == null) {
            throw new Exception("Missing source parameter.");
        }
        List filelist = sourceele.elements("file");
        for (int j = 0; j < filelist.size(); ++j) {
            Element envParam = run.element("envParam");
            Element httpParam = run.element("httpParam");
            Element systemParam = run.element("systemParam");
            Element fileElement = (Element)filelist.get(j);
            Element inElement = fileElement.element("in");
            if (inElement == null) {
                throw new Exception("Missing parameter - 'in'");
            }
            String file = inElement.getTextTrim();
            Document inputdoc = this.createInputDoc(envParam, httpParam, systemParam, file);
            this.processFile(lang, header, inputdoc, (Element)filelist.get(j), status);
        }
    }

    public void run(String[] args) throws Exception {
        if (!this.parseArg(args)) {
            this.usage();
            return;
        }
        Document doc = this.readInputFile();
        if (doc == null) {
            return;
        }
        int msglevel = 5;
        try {
            Element nestedMessage = doc.getRootElement().element("nestedMessage");
            if (nestedMessage != null) {
                String level = nestedMessage.getTextTrim();
                if (level != null && level.length() > 0) {
                    level = this.applyMacro(level, this.m_globalProp);
                }
                msglevel = Integer.parseInt(level);
            }
            boolean status = false;
            Element printStatus = doc.getRootElement().element("printStatus");
            if (printStatus != null) {
                String sStatus = printStatus.getTextTrim();
                if (sStatus == null || sStatus.length() == 0) {
                    System.out.println("Empty status parameter encountered.");
                }
                sStatus = this.applyMacro(sStatus, this.m_globalProp);
                status = sStatus.equals("true");
            }
            Properties prop = this.createOverrideProperties(doc, this.m_globalProp);
            XTSProcessor.getInstance(CALLER_ID).initialize(null, new XTSCmdLineResourceReader(), null, prop, true);
            List list = doc.getRootElement().elements();
            for (int i = 0; i < list.size(); ++i) {
                Element ele = (Element)list.get(i);
                if (ele.getName().equals("loop")) {
                    Element loopele = ele.createCopy();
                    this.processLoop(loopele, status, this.m_globalProp);
                    continue;
                }
                if (!ele.getName().equals("run")) continue;
                Element runele = ele.createCopy();
                this.processRun(runele, status, this.m_globalProp);
            }
            XTSProcessor.getInstance(CALLER_ID).terminate(true);
        }
        catch (XTSException e) {
            System.out.println("XTS exception encountered.");
            System.out.println("Root cause: ");
            System.out.println(e.getLastLocalizedMsgString(new Locale("en", ""), msglevel));
            throw e;
        }
        catch (Exception e) {
            System.out.println("Execution interrupted.");
            System.out.println("Root cause: ");
            System.out.println(e.getMessage());
            throw e;
        }
    }

    private Locale parseLang(String lang) {
        String country;
        String language;
        if (lang == null || lang.length() == 0) {
            return null;
        }
        int idx = lang.indexOf(45);
        if (idx != -1) {
            language = lang.substring(0, idx);
            int idx2 = lang.indexOf(45, idx + 1);
            country = idx2 != -1 ? lang.substring(idx + 1, idx2) : lang.substring(idx + 1);
        } else {
            language = lang;
            country = "";
        }
        language = language.toLowerCase();
        country = country.toUpperCase();
        if (language.length() != 2 || language.charAt(0) < 'a' || language.charAt(0) > 'z' || language.charAt(1) < 'a' || language.charAt(1) > 'z') {
            return null;
        }
        if (country.length() > 0 && (country.length() != 2 || country.charAt(0) < 'A' || country.charAt(0) > 'Z' || country.charAt(1) < 'A' || country.charAt(1) > 'Z')) {
            return null;
        }
        return new Locale(language, country);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(String lang, boolean header, Document doc, Element file, boolean status) throws XTSException, Exception {
        File parent;
        File outfile;
        Element inele = file.element("in");
        if (inele == null) {
            throw new Exception("Missing parameter - 'in'");
        }
        String in = inele.getTextTrim();
        if (in == null || in.length() == 0) {
            throw new Exception("Empty parameter - 'in'");
        }
        Element outele = file.element("out");
        if (outele == null) {
            throw new Exception("Missing parameter - 'out'");
        }
        String out = outele.getTextTrim();
        if (out == null || out.length() == 0) {
            throw new Exception("Empty parameter - 'out'");
        }
        if (status) {
            File iFile = new File(PropertiesManager.getInstance().getProperty("template.root"), in);
            File oFile = new File(out);
            System.out.println("  Executing template: ");
            System.out.println("    source : " + iFile.getAbsolutePath());
            System.out.println("    target : " + oFile.getAbsolutePath());
        }
        if ((outfile = new File(out)).isDirectory()) {
            throw new Exception("Parameter 'out' is a directory");
        }
        if (outfile.exists()) {
            outfile.delete();
        }
        if (!(parent = outfile.getParentFile()).exists()) {
            parent.mkdirs();
        }
        XTSEnvironment env = new XTSEnvironment(CALLER_ID);
        try {
            Locale locale = this.parseLang(lang);
            env.setLocale(locale);
            ArrayList lookupList = LocaleUtils.createLookupList(locale, false);
            env.setLookupList(lookupList);
            env.setMorphletName(in);
            XTSProcessor.getInstance(CALLER_ID).execute(in, doc, env);
            this.doOutput(env, doc, outfile, status, header);
            if (status) {
                System.out.println("    execute status: success.");
            }
        }
        finally {
            env.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOutput(XTSEnvironment env, Document doc, File outfile, boolean status, boolean header) throws Exception {
        Element protocolHdrEle;
        FileOutputStream os = new FileOutputStream(outfile);
        Element outputElement = doc.getRootElement().element("output");
        if (outputElement == null) {
            if (status) {
                System.out.println("    execute status: no output available.");
            }
            return;
        }
        if (header && (protocolHdrEle = outputElement.element(XTSConstants.ELEM_NM_ENTITYHEADER)) != null) {
            String paramName = null;
            Element paramElem = null;
            List paramElemList = protocolHdrEle.elements(XTSConstants.ELEM_NM_PARAM);
            StringBuffer hdrs = new StringBuffer();
            for (int i = 0; i < paramElemList.size(); ++i) {
                paramElem = (Element)paramElemList.get(i);
                paramName = paramElem.attributeValue("name");
                if (paramName == null || paramName.equals("Content-Length")) continue;
                hdrs.append(paramName + ": ");
                hdrs.append(paramElem.getText());
                hdrs.append("\r\n");
            }
            hdrs.append("\r\n");
            ((OutputStream)os).write(hdrs.toString().getBytes("UTF-8"));
        }
        byte[] buf = new byte[8192];
        int size = 0;
        List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
        for (int i = 0; i < partElemList.size(); ++i) {
            Element partElem = (Element)partElemList.get(i);
            ArrayList cleanUpObjList = new ArrayList();
            try {
                InputStream in = XTSOutputSpecUtils.generateInputStream(env, partElem, header, cleanUpObjList, null);
                while ((size = in.read(buf, 0, 8192)) != -1) {
                    ((OutputStream)os).write(buf, 0, size);
                }
                continue;
            }
            finally {
                for (XTSOutputObject outputObj : cleanUpObjList) {
                    outputObj.release();
                    outputObj = null;
                }
                cleanUpObjList.clear();
            }
        }
        if (outfile != null) {
            os.flush();
            ((OutputStream)os).close();
        }
    }

    public static void main(String[] args) {
        XTSRunner2 runner = new XTSRunner2();
        try {
            runner.run(args);
            System.gc();
            System.runFinalization();
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }
}

