/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.cache;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.util.RWLockManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class AXTSCacheFactory {
    private HashMap m_oObjectCache = new HashMap();
    private LinkedList m_oOrderList = new LinkedList();
    private int m_iCacheSize = 25;
    private RWLockManager m_oMutex = new RWLockManager(new Object());
    private boolean m_initialized = false;

    protected abstract int getCacheSize() throws XTSCacheException;

    protected abstract String getClassName(XTSEnvironment var1, Map var2) throws XTSCacheException;

    protected abstract String generateHashKey(XTSEnvironment var1, Map var2) throws XTSCacheException;

    protected abstract void preInitialize_Impl() throws XTSCacheException;

    protected abstract void postInitialize_Impl() throws XTSCacheException;

    protected abstract void preTerminate_Impl() throws XTSCacheException;

    protected abstract void postTerminate_Impl() throws XTSCacheException;

    public abstract String getIdentifier();

    public abstract boolean isSupported(XTSEnvironment var1, Map var2) throws XTSCacheException;

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void initialize() throws XTSCacheException {
        IXTSLogger logger;
        try {
            this.m_oMutex.writeLock();
            try {
                this.preInitialize_Impl();
                this.m_iCacheSize = this.getCacheSize();
                if (this.m_iCacheSize < 0) {
                    this.m_iCacheSize = 0;
                }
                this.postInitialize_Impl();
                this.m_initialized = true;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSCacheException("cachefactory.cacheinitfailed", e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getIdentifier(), null, null);
        }
    }

    public void terminate() throws XTSCacheException {
        IXTSLogger logger;
        try {
            this.m_oMutex.writeLock();
            try {
                this.preTerminate_Impl();
                Iterator it = this.m_oObjectCache.entrySet().iterator();
                while (it.hasNext()) {
                    AXTSCacheObject obj = (AXTSCacheObject)it.next().getValue();
                    if (obj == null) continue;
                    obj.release();
                    obj.terminate();
                }
                this.m_oObjectCache.clear();
                this.m_oOrderList.clear();
                this.m_iCacheSize = 0;
                this.postTerminate_Impl();
                this.m_initialized = false;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSCacheException("cachefactory.cachetermfailed", e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 1, this.getIdentifier(), null, null);
        }
    }

    public void reinitialize() throws XTSCacheException {
        this.terminate();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AXTSCacheObject getObject(XTSEnvironment env, Map atts) throws XTSCacheException {
        AXTSCacheObject obj;
        IXTSLogger logger;
        block15: {
            logger = null;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                logger.log(env, 4, this.getIdentifier() + " - getObject", null, null);
            }
            obj = null;
            try {
                String hashKey = this.generateHashKey(env, atts);
                if (hashKey == null) {
                    throw new XTSCacheException("cachefactory.nullhashkey");
                }
                this.m_oMutex.readLock();
                try {
                    obj = (AXTSCacheObject)this.m_oObjectCache.get(hashKey);
                    if (obj != null) {
                        obj.addRef();
                    }
                }
                finally {
                    this.m_oMutex.releaseReadLock();
                }
                if (obj != null) break block15;
                obj = this.createObject(env, atts);
                this.m_oMutex.writeLock();
                try {
                    if (this.m_iCacheSize > 0 && this.m_oObjectCache.get(hashKey) == null) {
                        while (this.m_oOrderList.size() >= this.m_iCacheSize) {
                            String key = (String)this.m_oOrderList.removeFirst();
                            if (key == null) continue;
                            this.m_oObjectCache.remove(key);
                        }
                        this.m_oObjectCache.put(hashKey, obj);
                        this.m_oOrderList.addLast(hashKey);
                        obj.addRef();
                    }
                    obj.addRef();
                }
                finally {
                    this.m_oMutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                throw new XTSCacheException("cachefactory.cachelockfailed", e);
            }
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && logger != null) {
            logger.log(env, 5, this.getIdentifier() + " - getObject", null, null);
        }
        return obj;
    }

    protected AXTSCacheObject createObject(XTSEnvironment env, Map atts) throws XTSCacheException {
        String className;
        IXTSLogger logger = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            logger.log(env, 4, this.getIdentifier() + " - createObject", null, null);
        }
        if ((className = this.getClassName(env, atts)) == null) {
            throw new XTSCacheException("cachefactory.nullclassname");
        }
        AXTSCacheObject obj = null;
        try {
            obj = (AXTSCacheObject)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            Object[] args = new String[]{className};
            throw new XTSCacheException("cachefactory.instantiationerror", args, e);
        }
        obj.initialize(env, atts);
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && logger != null) {
            logger.log(env, 5, this.getIdentifier() + " - createObject", null, null);
        }
        return obj;
    }
}

