/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.manager;

import com.cognos.xts.XTSException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;

public abstract class AXTSManager {
    protected boolean m_bInitialized = false;

    protected abstract boolean dependenciesCheck() throws XTSException;

    protected abstract void initialize_Impl() throws XTSException;

    protected abstract void terminate_Impl() throws XTSException;

    public abstract String getIdentifier();

    public void initialize() throws XTSException {
        IXTSLogger logger;
        if (!this.dependenciesCheck()) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSException("manager.depinitfailed", args);
        }
        this.initialize_Impl();
        this.m_bInitialized = true;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getIdentifier(), null, null);
        }
    }

    public void terminate() throws XTSException {
        IXTSLogger logger;
        this.terminate_Impl();
        this.m_bInitialized = false;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 1, this.getIdentifier(), null, null);
        }
    }

    public void reinitialize() throws XTSException {
        this.terminate();
        this.initialize();
    }

    public boolean isInitialized() throws XTSException {
        return this.m_bInitialized;
    }
}

