/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.pool;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AXTSUnlimitedPool {
    protected static final int INITSIZE = 2;
    protected static final int MAXSIZE = 10;
    private ConcurrentLinkedQueue<AXTSPoolObject> m_freeQueue = new ConcurrentLinkedQueue();
    protected boolean m_bInitialized = false;
    protected int m_initStickySize = 2;
    protected int m_maxStickySize = 10;
    protected int m_curStickySize = 0;

    protected abstract boolean dependenciesCheck() throws XTSException;

    protected abstract void initialize_Impl() throws XTSException;

    protected abstract void terminate_Impl() throws XTSException;

    protected abstract int getInitialSize();

    protected abstract int getMaxStickySize();

    protected abstract AXTSPoolObject createObject(boolean var1) throws XTSException;

    public abstract String getIdentifier();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AXTSPoolObject acquire() throws XTSException {
        AXTSPoolObject obj;
        while ((obj = this.m_freeQueue.poll()) != null) {
            if (obj.validate()) {
                return obj;
            }
            if (!this.m_freeQueue.isEmpty()) continue;
        }
        if (this.m_curStickySize < this.m_maxStickySize) {
            AXTSUnlimitedPool aXTSUnlimitedPool = this;
            synchronized (aXTSUnlimitedPool) {
                ++this.m_curStickySize;
            }
            return this.createObject(true);
        }
        return this.createObject(false);
    }

    public void put(AXTSPoolObject obj) {
        if (obj != null) {
            obj.put();
            this.m_freeQueue.add(obj);
        }
    }

    public synchronized void initialize() throws XTSException {
        IXTSLogger logger;
        if (!this.dependenciesCheck()) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSException("pool.depinitfailed", args);
        }
        this.m_freeQueue.clear();
        this.initialize_Impl();
        this.m_initStickySize = this.getInitialSize();
        this.m_maxStickySize = this.getMaxStickySize();
        this.m_curStickySize = 0;
        for (int i = 0; i < this.m_initStickySize; ++i) {
            ++this.m_curStickySize;
            this.m_freeQueue.add(this.createObject(true));
        }
        this.m_bInitialized = true;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getIdentifier(), null, null);
        }
    }

    public synchronized void terminate() throws XTSException {
        IXTSLogger logger;
        this.terminate_Impl();
        this.m_freeQueue.clear();
        this.m_initStickySize = 2;
        this.m_maxStickySize = 10;
        this.m_curStickySize = 0;
        this.m_bInitialized = false;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 1, this.getIdentifier(), null, null);
        }
    }

    public synchronized void reinitialize() throws XTSException {
        this.terminate();
        this.initialize();
    }

    public synchronized boolean isInitialized() throws XTSException {
        return this.m_bInitialized;
    }
}

