/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.pool.sax;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.AXTSUnlimitedPool;
import com.cognos.xts.common.pool.sax.XTSSoftSAXParser;
import com.cognos.xts.common.pool.sax.XTSStickySAXParser;
import com.cognos.xts.properties.PropertiesManager;

public class XTSSAXParserPool
extends AXTSUnlimitedPool {
    private static final String m_identifier = "XTSSAXParserPool";
    private static final String POOL_INITSIZE = "saxparserpool.initsize";
    private static final String POOL_MAXSIZE = "saxparserpool.maxsize";
    private static final XTSSAXParserPool m_instance = new XTSSAXParserPool();
    private int m_iPoolInitSize = 2;
    private int m_iPoolMaxSize = 10;

    public static XTSSAXParserPool getInstance() {
        return m_instance;
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return PropertiesManager.getInstance().isInitialized();
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        String sSize = PropertiesManager.getInstance().getProperty(POOL_INITSIZE);
        if (sSize != null) {
            try {
                this.m_iPoolInitSize = Integer.parseInt(sSize);
            }
            catch (NumberFormatException e) {
                Object[] args = new String[]{m_identifier};
                throw new XTSException("pool.poolsizefailed", args, e);
            }
        }
        if ((sSize = PropertiesManager.getInstance().getProperty(POOL_MAXSIZE)) != null) {
            try {
                this.m_iPoolMaxSize = Integer.parseInt(sSize);
            }
            catch (NumberFormatException e) {
                Object[] args = new String[]{m_identifier};
                throw new XTSException("pool.poolsizefailed", args, e);
            }
        }
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_iPoolInitSize = 2;
        this.m_iPoolMaxSize = 10;
    }

    @Override
    protected int getInitialSize() {
        return this.m_iPoolInitSize;
    }

    @Override
    protected int getMaxStickySize() {
        return this.m_iPoolMaxSize;
    }

    @Override
    protected AXTSPoolObject createObject(boolean permanent) throws XTSException {
        if (permanent) {
            return new XTSStickySAXParser();
        }
        return new XTSSoftSAXParser();
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }
}

