/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.pool.sax;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.lang.ref.SoftReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XTSSoftSAXParser
extends AXTSPoolObject {
    private static final String IDENTIFIER = "XTSSoftSAXParser";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final DefaultHandler m_defaultContentHandler = new DefaultHandler();
    private static SAXParserFactory m_factory = null;
    protected SoftReference softRef = null;

    public XTSSoftSAXParser() throws XTSException {
        if (m_factory == null) {
            throw new XTSException("pool.saxparserfactoryfailed");
        }
        try {
            IXTSLogger logger;
            SAXParser parser = m_factory.newSAXParser();
            this.hardRef = parser;
            this.softRef = new SoftReference<SAXParser>(parser);
            if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                logger.log(null, 8, "SAX Parser class: " + this.hardRef.getClass().getName(), null, null);
            }
        }
        catch (SAXException e) {
            throw new XTSException("pool.saxparserinitfailed", e);
        }
        catch (ParserConfigurationException e) {
            throw new XTSException("pool.saxparserinitfailed", e);
        }
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean validate() {
        this.hardRef = this.softRef.get();
        return this.hardRef != null;
    }

    @Override
    public void put() {
        try {
            XMLReader reader = ((SAXParser)this.hardRef).getXMLReader();
            reader.setContentHandler(m_defaultContentHandler);
            reader.setEntityResolver(m_defaultContentHandler);
            reader.setDTDHandler(m_defaultContentHandler);
            reader.setErrorHandler(m_defaultContentHandler);
            reader.setProperty(LEXICALHANDLER_PROPERTY, null);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.hardRef = null;
    }

    static {
        try {
            m_factory = SAXParserFactory.newInstance();
            try {
                m_factory.setFeature(NAMESPACE_FEATURE, true);
                m_factory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
            }
            catch (Exception e) {
                m_factory.setNamespaceAware(true);
            }
        }
        catch (Exception e) {
            m_factory = null;
        }
    }
}

