/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.pool.sax;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XTSStickySAXParser
extends AXTSPoolObject {
    private static final String IDENTIFIER = "XTSStickySAXParser";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final DefaultHandler m_defaultContentHandler = new DefaultHandler();
    private static SAXParserFactory m_factory = null;

    public XTSStickySAXParser() throws XTSException {
        if (m_factory == null) {
            throw new XTSException("pool.saxparserfactoryfailed");
        }
        try {
            IXTSLogger logger;
            this.hardRef = m_factory.newSAXParser();
            if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
                logger.log(null, 8, "SAX Parser class: " + this.hardRef.getClass().getName(), null, null);
            }
        }
        catch (SAXException e) {
            throw new XTSException("pool.saxparserinitfailed", e);
        }
        catch (ParserConfigurationException e) {
            throw new XTSException("pool.saxparserinitfailed", e);
        }
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void put() {
        try {
            XMLReader reader = ((SAXParser)this.hardRef).getXMLReader();
            reader.setContentHandler(m_defaultContentHandler);
            reader.setEntityResolver(m_defaultContentHandler);
            reader.setDTDHandler(m_defaultContentHandler);
            reader.setErrorHandler(m_defaultContentHandler);
            reader.setProperty(LEXICALHANDLER_PROPERTY, null);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    static {
        try {
            m_factory = SAXParserFactory.newInstance();
            try {
                m_factory.setFeature(NAMESPACE_FEATURE, true);
                m_factory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
            }
            catch (Exception e) {
                m_factory.setNamespaceAware(true);
            }
        }
        catch (Exception e) {
            m_factory = null;
        }
    }
}

