/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.common.thread;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.thread.IXTSRerunnable;
import com.cognos.xts.common.thread.XTSThreadPool;

public class XTSThread
extends Thread {
    IXTSRerunnable m_rerunnable = null;
    String m_name = null;
    long m_id = 0L;
    XTSThreadPool m_pool = null;
    boolean m_terminated = false;
    boolean m_ready = false;

    public XTSThread(ThreadGroup threadGroup, IXTSRerunnable rerunnable, String name, long id, XTSThreadPool pool) {
        super(threadGroup, rerunnable, name);
        this.m_rerunnable = rerunnable;
        this.m_name = name;
        this.m_id = id;
        this.m_pool = pool;
    }

    public synchronized void ready(long waittime) throws XTSException {
        if (!this.m_ready) {
            try {
                this.wait(waittime);
            }
            catch (InterruptedException e) {
                Object[] args = new String[]{this.m_name};
                throw new XTSException("thread.notready", args, e);
            }
            if (!this.m_ready) {
                Object[] args = new String[]{this.m_name};
                throw new XTSException("thread.notready", args);
            }
        }
    }

    @Override
    public synchronized void run() {
        this.m_ready = true;
        this.notify();
        try {
            do {
                this.wait();
                if (this.m_terminated) {
                    break;
                }
                this.m_rerunnable.run();
                if (this.m_terminated) break;
                if (!this.isInterrupted()) continue;
                break;
            } while (this.m_rerunnable.recycle() && this.m_pool.put(this, this.m_id));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_rerunnable.terminate();
        }
    }

    public synchronized void execute() {
        this.notify();
    }

    public synchronized void terminate() {
        this.m_terminated = true;
        this.notify();
    }

    public IXTSRerunnable getRerunnable() {
        return this.m_rerunnable;
    }

    public XTSThreadPool getPool() {
        return this.m_pool;
    }
}

