/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.logicsheet;

import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSLTFilter
extends Transformer {
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private XSLTFilter m_parent = null;
    private TransformerHandler m_handler = null;

    public XSLTFilter(TransformerHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null handler!");
        }
        this.m_handler = handler;
    }

    public void setParent(XSLTFilter parent) {
        this.m_parent = parent;
    }

    public XSLTFilter getParent() {
        return this.m_parent;
    }

    @Override
    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        block7: {
            try {
                this.m_handler.setResult(outputTarget);
                if (this.m_parent == null) {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    try {
                        factory.setFeature(NAMESPACE_FEATURE, true);
                        factory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                    }
                    catch (Exception e) {
                        factory.setNamespaceAware(true);
                    }
                    XMLReader reader = factory.newSAXParser().getXMLReader();
                    reader.setContentHandler(this.m_handler);
                    reader.setProperty(LEXICALHANDLER_PROPERTY, this.m_handler);
                    reader.parse(SAXSource.sourceToInputSource(xmlSource));
                    break block7;
                }
                this.m_parent.transform(xmlSource, new SAXResult(this.m_handler));
            }
            catch (ParserConfigurationException e) {
                throw new TransformerException(e.getMessage());
            }
            catch (SAXException e) {
                throw new TransformerException(e.getMessage());
            }
            catch (IOException e) {
                throw new TransformerException(e.getMessage());
            }
        }
    }

    @Override
    public void setParameter(String name, Object value) {
        this.m_handler.getTransformer().setParameter(name, value);
    }

    @Override
    public Object getParameter(String name) {
        return this.m_handler.getTransformer().getParameter(name);
    }

    @Override
    public void clearParameters() {
        this.m_handler.getTransformer().clearParameters();
    }

    @Override
    public void setURIResolver(URIResolver resolver) {
        this.m_handler.getTransformer().setURIResolver(resolver);
    }

    @Override
    public URIResolver getURIResolver() {
        return this.m_handler.getTransformer().getURIResolver();
    }

    @Override
    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        this.m_handler.getTransformer().setOutputProperties(oformat);
    }

    @Override
    public Properties getOutputProperties() {
        return this.m_handler.getTransformer().getOutputProperties();
    }

    @Override
    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        this.m_handler.getTransformer().setOutputProperty(name, value);
    }

    @Override
    public String getOutputProperty(String name) throws IllegalArgumentException {
        return this.m_handler.getTransformer().getOutputProperty(name);
    }

    @Override
    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.m_handler.getTransformer().setErrorListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.m_handler.getTransformer().getErrorListener();
    }
}

