/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.logicsheet;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheFactory;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import java.util.Map;

public class XTSLogicsheetCache
extends AXTSCacheFactory {
    private static final String IDENTIFIER = "XTSLogicsheetCache";
    public static final String ATT_KEY_PATH = "path";
    private static final String CACHE_SIZE = "logicsheetcache.size";
    private static XTSLogicsheetCache m_factory = new XTSLogicsheetCache();
    private int m_iCacheSize = 25;

    public static XTSLogicsheetCache getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() throws XTSCacheException {
        return this.m_iCacheSize;
    }

    @Override
    protected String getClassName(XTSEnvironment env, Map atts) throws XTSCacheException {
        return "com.cognos.xts.compiler.logicsheet.XTSLogicsheet";
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map atts) throws XTSCacheException {
        return (String)atts.get(ATT_KEY_PATH);
    }

    @Override
    protected void preInitialize_Impl() throws XTSCacheException {
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE);
        if (sCacheSize != null) {
            try {
                this.m_iCacheSize = Integer.parseInt(sCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSCacheException("logicsheet.cacheinitfailed", e);
            }
        }
    }

    @Override
    protected void postInitialize_Impl() throws XTSCacheException {
    }

    @Override
    protected void preTerminate_Impl() throws XTSCacheException {
    }

    @Override
    protected void postTerminate_Impl() throws XTSCacheException {
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean isSupported(XTSEnvironment env, Map atts) throws XTSCacheException {
        return true;
    }
}

