/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.logicsheet;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.compiler.XTSCompilerException;
import com.cognos.xts.compiler.logicsheet.XSLTFilter;
import com.cognos.xts.compiler.logicsheet.XTSLogicsheet;
import com.cognos.xts.compiler.logicsheet.XTSLogicsheetCache;
import com.cognos.xts.properties.PropertiesManager;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public class XTSLogicsheetTransfomer {
    private static final String TRANSFORMERFACTORY = "logicsheetcache.transform";
    private static final int BUFFER_SIZE = 4096;
    private static String m_factory = null;

    public static void initialize() throws XTSException {
        XTSLogicsheetCache.getInstance().initialize();
        String factory = PropertiesManager.getInstance().getProperty(TRANSFORMERFACTORY);
        if (factory == null || factory.length() <= 0) {
            throw new XTSCompilerException("logicsheet.cacheinitfailed");
        }
        m_factory = factory;
    }

    public static void terminate() throws XTSException {
        XTSLogicsheetCache.getInstance().terminate();
    }

    public static void reinitialize() throws XTSException {
        XTSLogicsheetTransfomer.terminate();
        XTSLogicsheetTransfomer.initialize();
    }

    public static Source applyLogicsheets(XTSEnvironment env, Source src, List lsFiles, URIResolver resolver) throws XTSCompilerException, XTSCacheException {
        return XTSLogicsheetTransfomer._applyLogicsheets(env, src, lsFiles, resolver);
    }

    public static Source applyLogicsheets(XTSEnvironment env, InputSource src, List lsFiles, URIResolver resolver) throws XTSCompilerException, XTSCacheException {
        Reader reader = src.getCharacterStream();
        if (reader != null) {
            StreamSource source = new StreamSource(reader);
            return XTSLogicsheetTransfomer._applyLogicsheets(env, source, lsFiles, resolver);
        }
        InputStream stream = src.getByteStream();
        if (stream != null) {
            StreamSource source = new StreamSource(stream);
            return XTSLogicsheetTransfomer._applyLogicsheets(env, source, lsFiles, resolver);
        }
        throw new XTSCompilerException("logicsheet.cacheinitfailed");
    }

    private static Source _applyLogicsheets(XTSEnvironment env, Source src, List lsFiles, URIResolver resolver) throws XTSCompilerException, XTSCacheException {
        if (src == null) {
            throw new XTSCompilerException("message.invalidsource");
        }
        SAXTransformerFactory factory = null;
        try {
            factory = (SAXTransformerFactory)Class.forName(m_factory).newInstance();
            if (resolver != null) {
                factory.setURIResolver(resolver);
            }
        }
        catch (IllegalAccessException e) {
            throw new XTSCompilerException("logicsheet.cacheinitfailed");
        }
        catch (InstantiationException e) {
            throw new XTSCompilerException("logicsheet.cacheinitfailed");
        }
        catch (ClassNotFoundException e) {
            throw new XTSCompilerException("logicsheet.cacheinitfailed");
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.put("factory", factory);
        StringWriter writer = new StringWriter(4096);
        StreamResult result = new StreamResult(writer);
        XSLTFilter curFilter = null;
        for (int i = 0; i < lsFiles.size(); ++i) {
            Object[] args;
            try {
                String lsFile = (String)lsFiles.get(i);
                atts.put("path", lsFile);
                XTSLogicsheet logicsheet = (XTSLogicsheet)XTSLogicsheetCache.getInstance().getObject(env, atts);
                Templates template = logicsheet.getTemplate();
                TransformerHandler handler = factory.newTransformerHandler(template);
                if (resolver != null) {
                    handler.getTransformer().setURIResolver(resolver);
                }
                XSLTFilter filter = new XSLTFilter(handler);
                if (curFilter == null) {
                    curFilter = filter;
                    continue;
                }
                filter.setParent(curFilter);
                curFilter = filter;
                continue;
            }
            catch (TransformerConfigurationException e) {
                args = new String[]{(String)lsFiles.get(i)};
                throw new XTSCacheException("message.transformfailed", args, e);
            }
            catch (XTSException e) {
                args = new String[]{(String)lsFiles.get(i)};
                throw new XTSCacheException("message.transformfailed", args, e);
            }
        }
        try {
            curFilter.transform(src, result);
        }
        catch (TransformerException e) {
            Object[] args = new String[]{lsFiles.toString()};
            throw new XTSCacheException("message.transformfailed", args, e);
        }
        return new StreamSource(new StringReader(writer.toString()));
    }
}

