/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.message;

import com.cognos.xts.compiler.message.Node;
import com.cognos.xts.compiler.message.XTSString;
import com.cognos.xts.ext.XTSExt;
import java.io.IOException;
import java.util.ArrayList;

public class XTSMessage {
    private static final int TEXT_NODE = 0;
    private static final int PARAM_NODE = 1;
    private String m_id = null;
    private ArrayList m_list = null;

    public XTSMessage(String id) {
        this.m_id = id;
        this.m_list = new ArrayList();
    }

    public String getId() {
        return this.m_id;
    }

    public void addText(String text) {
        this.m_list.add(new Node(0, text));
    }

    public void addText(char[] text) {
        this.m_list.add(new Node(0, text));
    }

    public void addText(char[] text, int offset, int count) {
        this.m_list.add(new Node(0, text, offset, count));
    }

    public void addParam(String name) {
        this.m_list.add(new Node(1, name));
    }

    public void addParam(char[] name) {
        this.m_list.add(new Node(1, name));
    }

    public void addParam(char[] name, int offset, int count) {
        this.m_list.add(new Node(1, name, offset, count));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_id);
        buf.append(": ");
        for (int i = 0; i < this.m_list.size(); ++i) {
            Node node = (Node)this.m_list.get(i);
            if (node.getType() == 0) {
                buf.append(node.getValue());
                continue;
            }
            buf.append("{").append(node.getValue()).append("}");
        }
        return buf.toString();
    }

    public String convert(XTSString str) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_list.size(); ++i) {
            Node node = (Node)this.m_list.get(i);
            if (node.getType() == 0) {
                String value = node.getValue();
                String encoding = str.getEncode();
                if (encoding != null && encoding.length() > 0) {
                    if (encoding.equals("url")) {
                        buf.append(XTSExt.urlencode(value));
                        continue;
                    }
                    if (encoding.equals("html")) {
                        buf.append(XTSExt.htmlencode(value));
                        continue;
                    }
                    if (encoding.equals("javascript")) {
                        buf.append(XTSExt.javascriptencode(value));
                        continue;
                    }
                    if (encoding.equals("xml")) {
                        buf.append(XTSExt.xmlencode(value));
                        continue;
                    }
                    buf.append(value);
                    continue;
                }
                buf.append(value);
                continue;
            }
            buf.append(str.getParam(node.getValue()));
        }
        return buf.toString();
    }
}

