/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.message;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.cache.AXTSFastCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.compiler.message.XTSMessage;
import com.cognos.xts.compiler.message.XTSMessageSAXHandler;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XTSMessageMap
extends AXTSFastCacheObject {
    private static final String IDENTIFIER = "XTSMessageMap";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private HashMap m_msgMap = null;

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected void initialize_Impl(XTSEnvironment env, Map atts) throws XTSCacheException {
        String path = (String)atts.get("path");
        Locale locale = (Locale)atts.get("locale");
        this.compile(env, path, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(XTSEnvironment env, String path, Locale locale) throws XTSCacheException {
        String filename = this.calculateMsgFileName(path, locale);
        InputStream msgStream = null;
        try {
            msgStream = XTSResourceManager.getInstance().getResource(filename);
        }
        catch (XTSException e) {
            Object[] args = new String[]{path};
            throw new XTSCacheException("message.messagefilemissing", args, e);
        }
        try {
            AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
            try {
                XTSMessageSAXHandler handler = new XTSMessageSAXHandler();
                XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                reader.setContentHandler(handler);
                reader.setProperty(LEXICALHANDLER_PROPERTY, handler);
                reader.parse(new InputSource(msgStream));
                this.m_msgMap = handler.getMessagesMap();
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
        }
        catch (SAXException e) {
            Object[] args = new String[]{path};
            throw new XTSCacheException("message.transformcompilefailed", args, e);
        }
        catch (IOException e) {
            Object[] args = new String[]{path};
            throw new XTSCacheException("message.transformcompilefailed", args, e);
        }
        catch (XTSException e) {
            Object[] args = new String[]{path};
            throw new XTSCacheException("message.transformcompilefailed", args, e);
        }
    }

    private String calculateMsgFileName(String path, Locale locale) {
        int dot;
        String localeSuffix = "";
        if (locale != null) {
            localeSuffix = "_" + LocaleUtils.toNormalizedString(locale);
        }
        String sMsgFileName = (dot = path.lastIndexOf(46)) != -1 ? path.substring(0, dot) + localeSuffix + path.substring(dot) : path + localeSuffix;
        return sMsgFileName;
    }

    public HashMap getMessageMap() {
        return this.m_msgMap;
    }

    public XTSMessage getXTSMessage(String id) {
        return (XTSMessage)this.m_msgMap.get(id);
    }
}

