/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.message;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheFactory;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.LocaleUtils;
import java.util.Locale;
import java.util.Map;

public class XTSMessageMapCache
extends AXTSCacheFactory {
    private static final String IDENTIFIER = "XTSMessageMapCache";
    public static final String ATT_KEY_PATH = "path";
    public static final String ATT_KEY_LOCALE = "locale";
    private static final String CACHE_SIZE = "messagecache.size";
    private static XTSMessageMapCache m_factory = new XTSMessageMapCache();
    private int m_iCacheSize = 25;
    private String m_sTemplateRoot = null;

    public static XTSMessageMapCache getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() throws XTSCacheException {
        return this.m_iCacheSize;
    }

    @Override
    protected String getClassName(XTSEnvironment env, Map atts) throws XTSCacheException {
        return "com.cognos.xts.compiler.message.XTSMessageMap";
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map atts) throws XTSCacheException {
        return (String)atts.get(ATT_KEY_PATH) + ":" + LocaleUtils.toNormalizedString((Locale)atts.get(ATT_KEY_LOCALE));
    }

    @Override
    protected void preInitialize_Impl() throws XTSCacheException {
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE);
        if (sCacheSize != null) {
            try {
                this.m_iCacheSize = Integer.parseInt(sCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSCacheException("message.cacheinitfailed", e);
            }
        }
    }

    @Override
    protected void postInitialize_Impl() throws XTSCacheException {
    }

    @Override
    protected void preTerminate_Impl() throws XTSCacheException {
    }

    @Override
    protected void postTerminate_Impl() throws XTSCacheException {
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean isSupported(XTSEnvironment env, Map atts) throws XTSCacheException {
        return true;
    }
}

